#ifndef __GAMEOBJECT_H__
#define __GAMEOBJECT_H__

class Scene;
class GameObject
{
public:
    GameObject();

public: 
    void setStartPosition(uint8_t x, uint8_t y);
    void setSpriteId(uint8_t spriteId);
    void setSpeed(uint8_t speed);
    void setCollisionRect(uint8_t x, uint8_t y, uint8_t w, uint8_t h);
    void animate();
    virtual void update();
    virtual void draw();
    
protected:        
    bool moveLeft();
    bool moveRight();
    bool moveUp();
    bool moveDown();
    bool fall();
    
    const GameObject* detectCollision();
    const Block* detectBlock();    
    Rect getCollisionRect();
    
    bool pickupObject();        
    
    bool canGoLeft(uint8_t x, uint8_t y);
    bool canGoRight(uint8_t x, uint8_t y);
    bool canGoUp(uint8_t x, uint8_t y);
    bool canGoDown(uint8_t x, uint8_t y, uint8_t collitionBorder);
    
    bool isOpenBelow();
    bool isOpenBelow(int8_t dx);
    bool isOverLadder();
    bool isLadderAbove();
    bool isLadderBelow();
    bool isLadderLeft();
    bool isLadderRight();
    const Block& getBlockAbove();
    const Block& getBlockBelow();
        
    inline Point& getPosition() {return _position;}    
    inline int8_t getLastXDirection() { return _lastdx; }
    
    void setScene(Scene *pScene) { _pScene = pScene; }
    Scene* getScene() { return _pScene; }
private:  
    uint8_t     _spriteId;
    Point       _position;
    int8_t     _dx;
    int8_t     _dy;
    int8_t     _lastdx;
    int8_t     _lastdy;
    uint8_t    _speed;
    uint8_t    _animationCounter;
    Rect       _collisionRect;
    bool       _flipSprite;
    
    Scene       *_pScene;
    
    friend class Scene;
};

#endif //__GAMEOBJECT_H__
