#ifndef __SOUNDBLOCK_H__
#define __SOUNDBLOCK_H__

#define US_PER_BIT  32

// Fix16 representation of 1000000/32
#define FREQ_NUMERATOR 0x7a120000

#define TONE(stepCount, stepDuration, pitch, pitchSlide, duty, dutySlide) SoundBlock(SoundBlock::Tone, stepCount, stepDuration, pitch, pitchSlide, duty, dutySlide)
#define NOISE(stepCount, stepDuration, pitch, pitchSlide) SoundBlock(SoundBlock::Noise, stepCount, stepDuration, pitch, pitchSlide, 128, 0)
#define PAUSE(stepCount, stepDuration) SoundBlock(SoundBlock::Pause, stepCount, stepDuration, 0, 0, 0, 0)

#define CREATE_EFFECT(name) \
static const SoundBlock name[] = \
{ \

#define END_EFFECT \
};

#define EFFECT(name) name, sizeof(name)/sizeof(SoundBlock)

class SoundChannel;

class SoundBlock
{
    public:
        enum ToneType {Tone, Noise, Pause};
        
    public:
        SoundBlock(ToneType toneType, uint16_t stepCount, uint16_t stepDuration, uint16_t pitch, int16_t pitchSlide, uint8_t duty, int8_t dutySlide);
        SoundBlock(ToneType toneType, uint16_t stepCount, uint16_t stepDuration);
        
    protected:
        SoundBlock();
    
    private:
        void initialize(ToneType toneType, uint16_t stepCount, uint16_t stepDuration, uint16_t pitch, int16_t pitchSlide, uint8_t duty, int8_t dutySlide);
        
    protected:
        inline ToneType getToneType() { return _toneType; }
        inline uint16_t getStepCount() { return _stepCount; }
        inline uint16_t getStepDuration() { return _stepDuration; }
        inline fix16_t getPitch(fix16_t offset) { return fix16_div(FREQ_NUMERATOR, _pitch + offset); }
        inline fix16_t getPitchSlide() {return _pitchSlide; }
        inline uint8_t getDuty(int8_t offset) { return (uint8_t)(_duty + offset); }
        inline int8_t getDutySlide() { return _dutySlide; }
        
    private:
        ToneType    _toneType;
        uint16_t    _stepCount;
        uint16_t    _stepDuration;
        fix16_t     _pitch;
        fix16_t     _pitchSlide;
        uint8_t     _duty;
        int8_t      _dutySlide;
        
    friend class SoundChannel;
};
#endif //__SOUNDBLOCK_H__


