
class BouncingEnemy : public GameObject
{
    public:
        BouncingEnemy(uint8_t spriteId) :            
            _dx(1),
            _dy(1)
        {
            setSpriteId(spriteId);
            setSpeed(1);            
        }
        
        virtual void update()
        {
            if (_dx > 0) 
            {
                if (!moveRight()) 
                {
                    _dx = -1;
                }
            }
            else if (_dx < 0)
            {
                if (!moveLeft()) 
                {
                    _dx = 1;
                }
            }
            
            if (_dy > 0) 
            {
                if (!moveDown()) 
                {
                    _dy = -1;
                }
            }
            else if (_dy < 0)
            {
                if (!moveUp()) 
                {
                    _dy = 1;
                }
            }
            
            animate();
        }
        
    private:        
        int8_t _dx;
        int8_t _dy;
};

