#include "GameEngine.h"
#include "SoundEffects.h"
#include "SpriteSheet.h"
#include "Player.h"
#include "PatrollingEnemy.h"
#include "BouncingEnemy.h"
#include "Assets.h"
#include "Maps.h"
#include "ScreenIntro.h"
#include "Screen1.h"
#include "Screen2.h"
#include "Screen3.h"
#include "Screen4.h"

class MyGame : public Game
{ 
    public:
        MyGame() :
            _screen(-1),
            _intro(true)
        {
            setScene(new ScreenIntro);             
        }
        
    private:
        int _screen;
        
        virtual void completeScreen()
        {
            _intro = false;
            if (_screen == 3)
            {
                increaseSpeed(10);
                addLives(1);
            }
            
            _screen = (_screen + 1) % 4;
            
            Scene *pCur = getScene();
            if (pCur != NULL) delete pCur;
            
            switch(_screen)
            {
                case 0 : setScene(new Screen1); break;
                case 1 : setScene(new Screen2); break;
                case 2 : setScene(new Screen3); break;
                case 3 : setScene(new Screen4); break;
            }
        };
        
        virtual void update()
        {
            static bool died = false;
            
            if (getLives() > 0)
            {
                Game::update();
            }                       
            else 
            {
                if (died == false)
                {
                    died = true;
                    PLAY_EFFECT(2, Sound_GameOver);
                }
            }            
        }
        
        virtual void draw()
        {            
            Game::draw();
            
            if (!_intro)
            {
                if (getLives() == 0) Surface.drawBitmap(52, 60, bmpText, 0, 0, 56, 8, Color565::White, Color565::Black);            
                
                Surface.drawBitmap(0, 0, bmpText, 0, 16, 32, 8, Color565::White, Color565::Black);                        
                drawNumber(34, 0, getLives());
                
                Surface.drawBitmap(72, 0, bmpText, 32, 16, 34, 8, Color565::White, Color565::Black);                        
                drawNumber(110, 0, getScore());
            }            
        }
        
    private:
        void drawNumber(int x, int y, int number)
        {
            sprintf(_textBuffer, "%d", number);
            for (char *p = _textBuffer; *p != 0; ++p, x += 8)
            {
                int sx = (*p - 48) * 8;                
                Surface.drawBitmap(x, y, bmpText, sx, 8, 8, 8, Color565::White, Color565::Black);                    
            }
        }        
    
    private:        
        char _textBuffer[15];
        bool _intro;
};



int main()
{               
    MyGame game;
    game.run();
}
    
