#ifndef __SCREENINTRO_H__
#define __SCREENINTRO_H__

class ScreenIntro : public Scene
{
public:
    ScreenIntro() :
        _player()
    {
        Game::Surface.clearScreen();
        
        addGameObject(&_player);
        
        restartScreen();
    }
    
    virtual void restartScreen()
    {
        _player.setIntroMode(true);
        _player.setStartPosition(72, 40);        
        
        setPosition(0, 16);
        setMap(Maps::ScreenIntro, 20, 7, blocks, sprites);
        
        Scene::restartScreen();
    }
    
    virtual void update()
    {
        Scene::update();
        
        if (GameInput::isSquarePressed()) Game::Instance->completeScreen();
    }
    
    virtual void draw()
    {
        Scene::draw();
        
        Game::Surface.drawBitmap(43, 8, bmpText, 0, 24, 74, 8, Color565::White, Color565::Black);
        Game::Surface.drawBitmap(43, 80, bmpText, 0, 32, 74, 8, Color565::White, Color565::Black);            
        Game::Surface.drawBitmap(44, 116, bmpText, 0, 40, 71, 8, Color565::White, Color565::Black);            
    }
    
private:    
    Player        _player;    
};

#endif //__SCREENINTRO_H__
