#ifndef __SCREEN4_H__
#define __SCREEN4_H__

class Screen4 : public Scene
{
public:
    Screen4() :
        _player(),
        _enemy1(3, PatrollingEnemy::LeftRight),
        _enemy2(4)              
    {
        Game::Surface.clearScreen();
                        
        addGameObject(&_enemy1);
        addGameObject(&_enemy2);                       
        addGameObject(&_player);
        
        restartScreen();
    }
    
    virtual void restartScreen()
    {
        _player.setStartPosition(10, 16);  
              
        _enemy1.setStartPosition(72, 48);  
        _enemy1.setCollisionRect(0, 6, 16, 16);
        
        _enemy2.setStartPosition(88, 78);       
                
        setPosition(0, 8);
        setMap(Maps::Screen4, 20, 15, blocks, sprites);
        
        Scene::restartScreen();
    }
    
private:    
    Player              _player;
    PatrollingEnemy     _enemy1;
    BouncingEnemy       _enemy2;
};

#endif //__SCREEN4_H__
