#ifndef __SCREEN1_H__
#define __SCREEN1_H__

class Screen1 : public Scene
{
public:
    Screen1() :
        _player(),            
        _enemy1(3, PatrollingEnemy::LeftRight),
        _enemy2(4)
    {
        addGameObject(&_enemy1);
        addGameObject(&_enemy2);            
        addGameObject(&_player);
        
        restartScreen();
    }
    
    virtual void restartScreen()
    {
        _player.setStartPosition(130, 96);
        
        _enemy1.setStartPosition(80, 72);
        _enemy1.setCollisionRect(0, 6, 16, 16);
        
        _enemy2.setStartPosition(8, 8);
        
        setPosition(0, 8);        
        setMap(Maps::Screen1, 20, 15, blocks, sprites);
        
        Scene::restartScreen();
    }
        
private:   
    Player          _player;     
    PatrollingEnemy _enemy1;
    BouncingEnemy   _enemy2;
};

#endif //__SCREEN1_H__