#ifndef __RECT_H__
#define __RECT_H__

#include <algorithm>

struct Rect
{
    uint8_t left;
    uint8_t top;
    uint8_t right;
    uint8_t bottom;
    
    Rect() :
        left(0),
        top(0),
        right(0),
        bottom(0)
    {
    }
    
    Rect(uint8_t l, uint8_t t, uint8_t w, uint8_t h) :
        left(l),
        top(t),
        right(l + (w - 1)),        
        bottom(t + (h - 1))
    {
    }
    
    Rect Intersection(Rect &rect)
    {
        uint8_t x1 = max(left, rect.left);
        uint8_t y1 = max(top, rect.top);
        uint8_t x2 = min(right, rect.right);
        uint8_t y2 = min(bottom, rect.bottom);
        
        return Rect(x1, y1, x2, y2); 
    }
    
    inline uint8_t getWidth() const { return right - left; }
    inline uint8_t getHeight() const { return bottom - top; }
};

#endif //__RECT_H__