#ifndef __IMAGEFRAME_H__
#define __IMAGEFRAME_H__

class ImageFrame
{
    public:
        ImageFrame(const uint8_t *pSheet, 
            uint8_t x, uint8_t y) :
            _stride((*((uint16_t*)pSheet)) >> 3),
            _pStart((pSheet + 4) + ((y * _stride) + (x >> 3)))            
        {            
        }
        
        inline uint8_t *getBits(int row) const
        {            
            return (uint8_t*)(_pStart + (row * _stride));
        }
        
    private:
        uint8_t         _stride;                
        const uint8_t   *_pStart;
        
};

#endif //__IMAGEFRAME_H__

