#ifndef __GAME_H__
#define __GAME_H__

#define PLAY_EFFECT(channel, name) Game::playEffect(channel, EFFECT(name));

class Game
{                
    public:
        Game();        
        void run();
        void die();
                
        virtual void completeScreen() = 0;

        inline void addScore(uint32_t score) { _score += score; }
        inline void subtractScore(uint32_t score) { _score -= score; }
        inline uint8_t getLives() { return _lives; }
        inline void addLives(uint8_t lives) { _lives += lives; }
        inline void increaseSpeed(uint16_t percent) { _speedAdjust += (32000 / 100 * percent); }
        inline void resetSpeed() { _speedAdjust = 0; }
    public:
        static Game *Instance;
        static LCD_ST7735 Surface;   
        
        static void playEffect(uint8_t channel, const SoundBlock *effect, uint8_t count);
         
    protected:           
        inline void setScene(Scene *pScene) { if (_pScene == NULL) _pScene = pScene; else _pNextScene = pScene; }
        inline Scene* getScene() { return _pScene; }
        inline void setLives(uint8_t lives) { _lives = lives; }        
        inline void decLives() { --_lives; }
        inline void setScore(uint32_t score) { _score = score; }
        inline uint32_t getScore() { return _score; }
        
        virtual void update();
        virtual void draw();
        
    private:        
        Scene       *_pScene;
        Scene       *_pNextScene;
        uint8_t     _lives;
        uint32_t    _score;
        uint16_t    _speedAdjust;
        
    friend class GameObject;
    friend class Scene;
};
#endif //__GAME_H__


