#ifndef __BLOCK_H__
#define __BLOCK_H__

class Block
{
public:
    enum Type { Background, Foreground, Platform, Solid, Ladder, Deadly, Pickup }; 
    
public:
    Block(const ImageFrame *frame, Type type, uint8_t foregroundColor, uint8_t backgroundColor) :
        _frame(frame),
        _type(type),
        _color((foregroundColor << 4) | backgroundColor),
        _data(0)
    {
    }
    
    Block(const ImageFrame *frame, Type type, uint8_t foregroundColor, uint8_t backgroundColor, uint8_t data) :
        _frame(frame),
        _type(type),
        _color((foregroundColor << 4) | backgroundColor),
        _data(data)
    {
    }
    
    inline uint8_t* getBits(int row) const { return _frame->getBits(row); }        
    inline uint8_t getForegroundColor() const { return _color >> 4; }    
    inline uint8_t getBackgroundColor() const { return _color & 0x0f; }    
    inline uint8_t getData() const { return _data; }
    inline Type getType() const { return (Type)_type; }
    
private:
    const ImageFrame    *_frame;
    uint8_t             _type;
    uint8_t             _color;  
    uint8_t             _data;  
};

#endif //__BLOCK_H__


