#ifndef __FIX16_H__
#define __FIX16_H__

#define FIX_SHIFT   16

typedef int32_t fix16_t;

static const fix16_t fix16_one = 1 << FIX_SHIFT;
static const fix16_t fix16_100  = 100 << FIX_SHIFT;
static const fix16_t fix16_half = 0x00008000;


static inline fix16_t fix16_add(fix16_t x, fix16_t y) { return x + y; }
static inline fix16_t fix16_sub(fix16_t x, fix16_t y) { return x - y; }
static inline fix16_t fix16_mul(fix16_t x, fix16_t y) { return (fix16_t)(((int64_t)x * y) >> FIX_SHIFT); }
static inline fix16_t fix16_div(fix16_t x, fix16_t y) { return (fix16_t)(((int64_t)x << FIX_SHIFT) / y); }

static inline fix16_t fix16_from(int x) { return x << FIX_SHIFT; }
static inline fix16_t fix16_from(float x) { return (fix16_t)(fix16_one * x); }

static inline int fix16_to_int(fix16_t x) { return x >> FIX_SHIFT; }
static inline float fix16_to_float(fix16_t x) { return (float)x / fix16_one; }

#endif //__FIX16_H__