#include "mbed.h"
#include "Color565.h"
#include "font_IBM.h"
#include "font_OEM.h"
#include "LCD_ST7735.h"

static const uint16_t bmp[] = {
    0x20, 0x10,
    0x0000, 0x0000, 0x1081, 0x41e4, 0x7b87, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0x7b87, 0x41e4, 0x1081, 0x0000, 0x0000, 0x0000, 0x0000, 0x1081, 0x4204, 0x7b87, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0x5a85, 0x4204, 0x1081, 0x0000, 0x0000, 
    0x0000, 0x1081, 0x5285, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0x5285, 0x1081, 0x0000, 0x0000, 0x1081, 0x5a85, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0x5a85, 0x1081, 0x0000, 
    0x1081, 0x5285, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0x5285, 0x1081, 0x1081, 0x5a85, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0x5a85, 0x1081, 
    0x41e4, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0x41e4, 0x4204, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0x4204, 
    0x7b87, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0x7b87, 0x83a8, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0x7b87, 
    0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0x0000, 0x4204, 0x5aa5, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 
    0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0x0000, 0x0000, 0x1081, 0x4204, 0x62c5, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 
    0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0x0000, 0x0000, 0x0000, 0x0000, 0x1081, 0x4204, 0x5aa5, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 
    0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1081, 0x5244, 0x5aa5, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 
    0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0x0000, 0x0000, 0x1081, 0x4204, 0x4204, 0x6b06, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 
    0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0x0000, 0x4204, 0x5a85, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 
    0x7b87, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0x7b87, 0x83a8, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0x7b87, 
    0x41e4, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0x41e4, 0x4204, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0x4204, 
    0x1081, 0x5285, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0x5285, 0x1081, 0x1081, 0x5a85, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0x5a85, 0x1081, 
    0x0000, 0x1081, 0x5285, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0x5285, 0x1081, 0x0000, 0x0000, 0x1081, 0x5a85, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0x5a85, 0x1081, 0x0000, 
    0x0000, 0x0000, 0x1081, 0x41e4, 0x7b87, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0x7b87, 0x41e4, 0x1081, 0x0000, 0x0000, 0x0000, 0x0000, 0x1081, 0x4204, 0x7b87, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0xff2f, 0x5a85, 0x1081, 0x0000, 0x0000, 
};

LCD_ST7735 Surface(
    P0_19,
    P0_20,
    P0_7,
    P0_21,
    P0_22,
    P1_15,
    P0_2,
    LCD_ST7735::RGB);

const char *text = "LCD Demo";

main()
{
    Surface.setOrientation(LCD_ST7735::Rotate270, false);
    
    Surface.setForegroundColor(Color565::White);
    Surface.setBackgroundColor(Color565::Blue);
    
    uint8_t width;
    uint8_t height;
    int     x;
    
    Surface.measureString(font_ibm, text, width, height);
    x = (160 - width) / 2;
    Surface.drawString(font_ibm, x, 0, "LCD Demo");
    Surface.fillRect(x, height + 2, x + width, height + 4, Color565::Red, Color565::Red);
        
    Surface.measureString(font_oem, text, width, height);
    x = (160 - width) / 2;
    Surface.drawString(font_oem, x, 16, "LCD Demo");
    Surface.fillRect(x, 16 + height + 2, x + width, 16 + height + 4, Color565::Green, Color565::Green);
    
    
    while (true) {
        Surface.drawBitmap(72, 56, bmp, 0, 0, 16, 16);
        wait_ms(150);
        Surface.drawBitmap(72, 56, bmp, 16, 0, 16, 16);
        wait_ms(150);
    }    
}
