#include "mbed.h"
#include "uLCD_4DGL.h"
#include "TextLCD.h"
#include <mpr121.h>

// on-board LEDs
DigitalOut led1 ( LED1 ) ;
DigitalOut led2 ( LED2 ) ;
DigitalOut led3 ( LED3 ) ;
DigitalOut led4 ( LED4 ) ;

//  COM port 
Serial com ( USBTX , USBRX , 9600 ); 

//  keypad
InterruptIn interrupt ( p26 ) ; 
I2C i2c ( p9 , p10 ) ;
Mpr121 keypad ( & i2c , Mpr121::ADD_VSS ) ; 

#define LCD_ON 1

//  LCD ( tx , rx , reset )
#if LCD_ON
uLCD_4DGL lcd ( p28 , p27 , p5 ) ;
#endif

//  flow meter
InterruptIn pulse_interrupt ( p11 ) ;
int unsigned pulse_count ( 0 ) ;
float pulse_milliLiters ( )
{
    float const factor ( 300.0f / 206.0f ) ;
    return ( ( float ) pulse_count * factor ) / 0.450f ;
}
void pulse ( ) 
{
    ++ pulse_count ;
    led4 = ! led4 ;
#if LCD_ON
    lcd.locate ( 4 , 8 ) ;
    lcd.printf ( "%f mL" , pulse_milliLiters ( ) ) ;
#endif
}

void read_pin ( )
{
#if LCD_ON
    lcd.filled_rectangle ( 0 , 0 , 128 , 128 , BLACK ) ; 
    lcd.locate ( 4 , 6 ) ;
    lcd.printf ( "Enter PIN" ) ; 
    lcd.locate ( 4 , 7 ) ;
    lcd.printf ( "on keypad" ) ;
#endif
}

enum
{
    pin_row = 8 , pin_col = 6
} ;

int unsigned pin_count ( 0 ) ;
int unsigned pin_value ( 0 ) ;

void keypad_callback ( ) 
{
    led2 = ! led2 ;
    
    int value ( keypad.read(0x00) ) ; value += keypad.read(0x01) << 8 ;

    switch ( value ) // map keys to keypad values
    {
        case 0 : return ; // key release

        case 0x1 : 
            // DELETE
//            lcd.locate ( pin_col + pin_count , pin_row ) ;
//            lcd.printf ( " " ) ;
            if ( pin_count != 0 ) 
            {
                -- pin_count ;
            }
            pin_value /= 10 ;
            return ; 
             
        case 0x100 :
            // DONE
            com.printf ( "a%020f\n" , pulse_milliLiters ( ) ) ;
#if LCD_ON
            lcd.locate ( 0 , 10 ) ;
            lcd.printf ( "Done pouring." ) ;
#endif 
            pulse_count = 0 ;
            read_pin ( ) ;
            return ;

        case 0x10 : pin_value = pin_value * 10 ; break ; // 0
        case 0x2 : pin_value = pin_value * 10 + 1 ; break ; // 1
        case 0x20 : pin_value = pin_value * 10 + 2 ; break ; // 2
        case 0x200 : pin_value = pin_value * 10 + 3 ; break ; // 3
        case 0x4 : pin_value = pin_value * 10 + 4 ; break ; // 4
        case 0x40 : pin_value = pin_value * 10 + 5 ; break ; // 5
        case 0x400 : pin_value = pin_value * 10 + 6 ; break ; // 6
        case 0x8 : pin_value = pin_value * 10 + 7 ; break ; // 7
        case 0x80 : pin_value = pin_value * 10 + 8 ; break ; // 8
        case 0x800 : pin_value = pin_value * 10 + 9 ; break ; // 9
    }
    
#if LCD_ON
    lcd.locate ( pin_col + pin_count , pin_row ) ;
    lcd.printf ( "*" ) ;
#endif 

    if ( pin_count == 3 )
    {
        com.printf ( "p%04d\n\r" , pin_value ) ; // transmit pin
    
        pin_value = pin_count = 0 ; // reset pin
    
        char readbuffer [ 2 ] ;
        com.gets ( readbuffer , 2 ) ; // receive verification
    
#if LCD_ON
        lcd.locate ( 4 , 6 ) ;
#endif
        switch ( readbuffer [ 0 ] ) // parse verification
        {
            case '0' : // INVALID
                led3 = ! led3 ;
#if LCD_ON
                lcd.filled_rectangle ( 0 , 0 , 128 , 128 , RED ) ;  
                lcd.locate ( 4 , 5 ) ;
                lcd.printf ( "INVALID PIN" ) ;
                wait_ms ( 1024 ) ;
#endif 
                read_pin ( ) ;
                break ;
                
            case '1' : // VALID
                led4 = ! led4 ;
                char buffer [ 6 ] ;
                com.gets ( buffer , sizeof ( buffer ) ) ;
#if LCD_ON
                lcd.filled_rectangle ( 0 , 0 , 128 , 128 , GREEN ) ;   
                lcd.printf ( "Pour beer" ) ;
//                lcd.locate ( 4 , 8 ) ;
                lcd.locate ( 4 , 10 ) ;
                lcd.printf ( "Current owed: $%s" , buffer ) ;
#endif
                break ;
                
            default: // ERROR
#if LCD_ON
                lcd.filled_rectangle ( 0 , 0 , 128 , 128 , YELLOW ) ; 
                lcd.printf ( "TRANSMISSION ERROR" ) ;
#endif
                led2 = ! led2 ;
                exit ( 1 ) ;
                break ;
        }
        return ;
    }
    ++ pin_count ; 
}
    
int main ( ) 
{
    pulse_interrupt.rise ( & pulse ) ;
    interrupt.fall ( & keypad_callback ) ;   
    interrupt.mode ( PullUp ) ;
    
    read_pin ( ) ;

    while(1) 
    {
        led1 = 1;
        wait(0.2);
        led1 = 0;
        wait(0.2);
    }
}
