#include <stdio.h>
#include <stdlib.h>
#include <time.h>      
#include "mbed.h"
#include "rtos.h"
#include "DebounceIn.h"
#include "TextLCD.h"
#include "LSM9DS1.h"
#include "SDFileSystem.h"
#include "uLCD_4DGL.h"
#include "wave_player.h"
#include "Nav_Switch.h"

#define WAV_FILE "/sd/music_cropped/Game music.wav"

#define LOG( ... ) pc.printf( __VA_ARGS__ ); 

//  LEDs on mbed
BusOut led(LED1,LED2,LED3,LED4);

//  debugging via pc 
Serial pc( USBTX , USBRX );

//  SD card
SDFileSystem sd( p5 , p6 , p7 , p8 , "sd" );

//  text display ( rs , e , d4-d7 )
//TextLCD txt( p22 , p23 , p24 , p25 , p26 , p27 );

//  LCD ( tx , rx , reset )
uLCD_4DGL lcd( p28 , p27 , p30 ); 

//  speaker
AnalogOut DACout( p18 );
PwmOut PWMout( p26 );
wave_player waver( & DACout , & PWMout );

//  pushbutton 
DebounceIn pb( p15 );

//  IMU ( sda , scl , ... )
LSM9DS1 imu( p9 , p10 , 0xD6 , 0x3C );

// 
Nav_Switch nav( p21 , p22 , p13 , p12 , p23 );

class Bullet;

void music_thread( void const * args ) {
    while( 1 ) {
        FILE *fp = fopen( WAV_FILE , "r");
        if ( fp ) {
//            LOG( ">>> Opened .wav file '%s'.\n" , WAV_FILE )
            waver.play( fp );
//            LOG( ">>> Played .wav file '%s'.\n" , WAV_FILE )
            fclose( fp );
//            LOG( ">>> Closed .wav file '%s'.\n" , WAV_FILE )
        } else {
//            LOG( "ERROR: could not open the .wav file.\n" );     
        }    
//        Thread::wait( 120 );
    }
}

class Shield
{
    friend Bullet ;
    static int const height = 5 ;
    static int const color = RED ;
public:
    Shield( int x , int dx , int y , int dy ) :
        _x( x ) , _dx( dx ) , _y( y ) , _dy( dy ) , _speed( 9 ) , _base( 15 ) , _dbase( 0 )
    {
    }
    void read( )
    {
        if ( nav.right( ) )
        {
            _dx = + _speed ;
        } else if ( nav.left( ) )
        {
            _dx = - _speed ;
        } else
        {
            _dx = 0 ;
        }
    }
    void draw( )
    {
        lcd.filled_rectangle(
            _x - _base , _y , 
            _x + _base , _y + height,
            BLACK
        );     
        _x += _dx;
        if ( _dbase )
        {
            _base += _dbase ;
            if ( _speed <= 1 )
            {
                pc.printf("Shield WINS\n") ;
            }
            else pc.printf("Shield speed: %d\n" , _speed);
            _dbase = 0 ;
            _x = 128/2 ;
        }
        else 
        {
            if ( _x + _base >= 127 )
            {
                _x = 127 - _base ;
                _dx = 0 ;
            }
            else if ( _x - _base <= 0 )
            {
                _x = 0 + _base ;
                _dx = 0 ;
            }
        }
        lcd.filled_rectangle(
            _x - _base , _y , 
            _x + _base , _y + height,
            color
        );     
    }
private:
    // 
    int _x ;
    int _dx ; 
    // 
    int _y ;
    int _dy ;
    // 
    int _speed ; 
    int _base ;
    int _dbase ;
};

class Bullet
{
    static int const base = 1 ;
    static int const height = 3 ;
    static int const color = WHITE ;
    
public:
    Bullet( int x , int dx , int y , int dy , bool off ) :
        _x( x ) , _dx( dx ) , _y( y ) , _dy( dy ) , _off( off )
    {
    }
    bool off( ) const { return _off ; }
    void shoot( int x , int dx , int y , int dy )
    {
        _off = false ;
        _x = x ; _dx = dx ; _y = y ; _dy = dy ;
    }
    void draw( Shield & shield )
    {
        if ( _off )
            return ;
        lcd.filled_rectangle(
            _x - base , _y - height , 
            _x + base , _y ,
            BLACK
        );     
        _x += _dx;
        _y += _dy;
        if ( _x + base >= 127 )
        {
            _x = 127 - base ;
            _dx = - (_dx / 2);
        }
        else if ( _x - base <= 0 )
        {
            _x = 0 + base ;
            _dx = - _dx / 2;
        }
        if ( _y - height <= 0)
        {
            _off = true ;
            lcd.media_init();
            lcd.set_sector_address(0x003A,0x7C01);
            lcd.display_image(0,0);
            Thread::wait(1000);
            lcd.filled_rectangle(0 ,0 ,128 ,128,BLACK);
            _y = 128 ;
            return ;
        } 
        else if ( _y - height < shield.height )
        {
            pc.printf("( _y - height < shield.height )\n");
            if ( ( _x <= shield._x + shield._base )
            && ( _x >= shield._x - shield._base ) )
            {
                pc.printf("COLLISION\n");
                // collision
                
                shield._dbase = 5 ;
                shield._speed -= 1 ; 
                _off = true ;
                _y = 127 ;
                if ( shield._base > 126/2 )
                {
                    shield._base = 15 ;
                    shield._dbase = 0 ;
                    shield._speed = 9 ; 
                    lcd.media_init();
                    lcd.set_sector_address(0x003A,0x7C42);
                    lcd.display_image(0,0);
                    Thread::wait(1000);
                    lcd.filled_rectangle(0 ,0 ,128 ,128,BLACK);     
                    return;
                    // shield wins
//                    shield._base = 128/2 ;
                 }
                return ;
//                shield._x = 128/2 ;                
            }
        }
        lcd.filled_rectangle(
            _x - base , _y - height , 
            _x + base , _y ,
            color
        );     
    }
private:
    int _x , _dx ;
    int _y , _dy ;
    bool _off ;
};

class Ship
{    
    static int const base = 5 ;
    static int const height = 15 ;
    static int const color = GREEN ;
    
public:
    Ship( int x , int dx , int y , int dy ) :
        _x( x ) , _dx( dx ) , _y( y ) , _dy( dy ) , _bullet( 0 , 0 , 0 , 0 , true )
    {
    }
    
    void read( )
    {
        if ( ( ! pb.read( ) ) & _bullet.off( ) )
        {
            _bullet.shoot( _x , _dx , _y - height , -9 ) ;
        }
        while( ! imu.accelAvailable( ) );
        imu.readAccel( );
        float ay( imu.calcAccel(imu.ay) );   
        _dx -= (int) ( ay * 2.4f ) ;
//        pc.printf("accel: %9f %9f %9f (%d)in Gs\n\r", imu.calcAccel(imu.ax), ay, imu.calcAccel(imu.az),_dx);
      
    }
    void draw( Shield & shield )
    {
        lcd.triangle(
            _x , _y - height ,
            _x - base , _y , 
            _x + base , _y ,
            BLACK
        );     
        _x += _dx;
        if ( _x + base >= 127 )
        {
            _x = 127 - base ;
            _dx = - (_dx / 2);
        }
        else if ( _x - base <= 0 )
        {
            _x = 0 + base ;
            _dx = - _dx / 2;
        }
        lcd.triangle(
            _x , _y - height ,
            _x - base , _y , 
            _x + base , _y ,
            color
        );     
        _bullet.draw( shield ) ;
    }
    
private:
    // center of triangle
    int _x ;
    int _dx ; 
    // bottom of triangle
    int _y ;
    int _dy ; 
    Bullet _bullet ;
};



class Game
{
    static int const enemy_colors [4];
    enum
    {
        screen_width = 128 , screen_height = 128 ,
        enemy_count  = sizeof(enemy_colors) / sizeof(enemy_colors[0])
    };
        
public:

    Game( ) :
        _ship( screen_width/2 , 0 , screen_height-1 , 0 ) ,
        _shield( screen_width/2 , 0 , 0 , 0 )
    {
    }
    void read( )
    {
        _ship.read( );
        _shield.read( );
    }
    void draw( )
    {
        _ship.draw( _shield );
        _shield.draw( );
    }
    void wait( )
    {
        Thread::wait( 20 );
    } 
private:
    Ship _ship ;
    Shield _shield ;
//    Enemy _enemy [ enemy_count ] ;
};
int const Game::enemy_colors [4] = {
    RED , GREEN , BLUE , RED|GREEN 
};

//
int main( ) 
{
    pc.printf( " -- INIT -- \n" );
    srand( time( NULL ) );
    pb.set_debounce_us( 1000 );
    pb.mode( PullUp );
    
    if ( ! imu.begin( ) ) {
        pc.printf("Failed to communicate with LSM9DS1.\n");
    }
    imu.calibrate( 1 );
//    imu.calibrateMag( 0 );
    
    Thread music( music_thread , (void *)"MUSIC" );
    
    Game game;
    
    while ( 1 )
    {        
        game.read( );
        game.draw( );
        game.wait( );
    }
    
    pc.printf( " -- DONE -- \n" );
}
