#include "mbed.h"
#include "EthernetNetIf.h"
#include "TCPSocket.h"
#include "netif.h"

/*
#Use the following python script as server

import os.path
from socket import *
from datetime import *

HOST = ''
PORT = 1234
ADDR = (HOST,PORT)
BUFSIZE = 4096
 
serv = socket(AF_INET,SOCK_STREAM)

serv.bind((ADDR))
serv.listen(5)
print 'listening...'
while 1:
    conn,addr = serv.accept()
    print 'Someone connected from %s' % (addr[0])
    print addr 
    i = 0
    while(1):
        filename = str(i)+".txt"
        if not os.path.isfile(filename):
            break
        i=i+1
        
    FILE = open(filename,"w")
    starttime = datetime.now()
    amount = 0
    while(1):
        data = conn.recv(BUFSIZE)
        if data:
            if len(data) > 0:
                amount += len(data)
                FILE.write(data)
                conn.recv(BUFSIZE)
        else:
            print "disconnected"
            break;
        
        c = (datetime.now() - starttime)
        milliseconds = (c.days * 24 * 60 * 60 + c.seconds) * 1000 + c.microseconds / 1000.0
        if milliseconds > 0:
            print "%d bytes in %f seconds -> %f B/s" % (amount , (milliseconds/1000.0), amount / (milliseconds/1000.0))
    conn.close()
    FILE.close()
    
*/



EthernetNetIf *eth; 

//Socket to upload data
Host* tcpAddr;
TCPSocket* tcp;
bool socket_writable = false;
bool socket_connected = false;

#define PACKET_SIZE 300
#define PACKET_COUNT 20


unsigned long x = 0;
char buffer[PACKET_SIZE];

void sendNextChunk()
{
    if(x<PACKET_SIZE*PACKET_COUNT)
    {
        unsigned long y = x;
        for(int i=0;i<PACKET_SIZE;i++)
        {
            buffer[i]=(y++)%256;
        }
        int ret = tcp->send(buffer, PACKET_SIZE);
        if(ret > 0)
        {
            x+=ret;
            printf("%d \r\n", x);
        }
        else
        {
            printf("some error: %d\r\n", ret);
        }
    }
}


void onTCPSocketEvent(TCPSocketEvent e)
{
    time_t t_seconds = time(NULL);
    switch(e)
    {
        case TCPSOCKET_CONNECTED:
            printf("Connected\r\n");
        case TCPSOCKET_WRITEABLE:
            sendNextChunk();
            break;
        case TCPSOCKET_READABLE:
            break;
        case TCPSOCKET_CONTIMEOUT:
        case TCPSOCKET_CONRST:
        case TCPSOCKET_CONABRT:     
        case TCPSOCKET_ERROR:
            socket_writable = false;
            printf("%s Connection Error: %i\r\n", ctime(&t_seconds),e);
            tcp->close();
            socket_connected=false;
            break;
        case TCPSOCKET_DISCONNECTED:
            socket_writable = false;
            printf("%s Disconnected\r\n", ctime(&t_seconds));
            tcp->close();
            socket_connected=false;
            break;
        default:
            printf("%s Unknown callback\r\n", ctime(&t_seconds));
            break;    
    }
}

int main() 
{
    eth = new EthernetNetIf();
    tcp = new TCPSocket();
    tcp->setOnEvent(&onTCPSocketEvent);
    EthernetErr ethErr = eth->setup();       // thats using dhcp
    if( ethErr == ETH_OK )
    {
        IpAddr ip = eth->getIp();
        printf("mbed IP Address is %d.%d.%d.%d\r\n", ip[0], ip[1], ip[2], ip[3]);
    }
    tcpAddr = new Host(IpAddr(192,168,1,18), 1234, "");
    IpAddr ip = tcpAddr->getIp();
    printf("Server IP Address is %d.%d.%d.%d\r\n", ip[0], ip[1], ip[2], ip[3]);
    tcp->connect(*tcpAddr);
    Timer t;
    t.start();
    printf("start\r\n");
    while(x<PACKET_SIZE*PACKET_COUNT)
    {
        Net::poll();
    }
    printf("stop\r\n");
    tcp->close();
    t.stop();
    printf("%d bytes in %f seconds %f\r\n", PACKET_SIZE*PACKET_COUNT, t.read(), (PACKET_SIZE*PACKET_COUNT)/t.read());
    while(1){}
}
