//相互通信確認用
#include "mbed.h"
#include "ADXL345_I2C.h"
#define BUFFER 30

Serial rs485(p13,p14);
Serial pc(USBTX,USBRX);
DigitalOut Receiver(p5);
ADXL345_I2C accelerometer(p9, p10);
PwmOut servo1(p21);
PwmOut servo2(p22);

int counter = 0;
int servo_deg1 = 0;
int servo_deg2 = 0;

int acc[3] = {0,0,0};

void rs485_rx()
{
    signed char rec_data = rs485.getc();
    switch(rec_data) {
        case 'A':
            servo_deg1 = rs485.getc();
            pc.printf("counter1:%d\n\r",servo_deg1);
            break;
        case 'B':
            servo_deg2 = rs485.getc();
            //pc.printf("counter2:%d\n\r",servo_deg2);
            break;
        case 'C':
            Receiver = 1;
            wait_ms(1);
            rs485.putc('X');
            rs485.putc((signed char)acc[0]);
            rs485.putc('Y');
            rs485.putc((signed char)acc[1]);
            rs485.putc('Z');
            rs485.putc((signed char)acc[2]);
//            rs485.printf("X%iY%iZ%i\n\r",(short)acc[0],(short)acc[1],(short)acc[2]);
            wait_ms(2);
            Receiver = 0;
            //pc.printf("x:%d,y:%d,z:%d\n\r",(signed char)acc[0],(signed char)acc[1],(signed char)acc[2]);
            break;
        default:
            wait_us(5);
            pc.printf("%d\n\r",rec_data);
    }
}

void init()
{
    Receiver = 0;
    pc.printf("Receiver\n\r");

    rs485.baud(38400);
    rs485.attach(rs485_rx, Serial::RxIrq);

    servo1.period_ms(20);
    servo2.period_ms(20);

    accelerometer.setPowerControl(0x00);
    accelerometer.setDataFormatControl(0x0B);
    accelerometer.setDataRate(ADXL345_3200HZ);
    accelerometer.setPowerControl(0x08);
}

int main()
{
    init();
    while(1) {
        accelerometer.getOutput(acc);
        servo1.pulsewidth(0.00093 + (servo_deg1 / 180.0) * (0.00235 - 0.00077));
        servo2.pulsewidth(0.00093 + (servo_deg2 / 180.0) * (0.00235 - 0.00077));
        wait_ms(10);
    }
}
