#include "mbed.h"
#include "HMC5883L.h"

HMC5883L::HMC5883L(I2C* p_i2c): i2c(p_i2c) {}

HMC5883L::~HMC5883L() {
    i2c = NULL;
}

int HMC5883L::init() {
    return 1;
}

int HMC5883L::read() {
    char cmd[2] = {0x02, 0x01};
    int ret = i2c->write(hmc_addr, cmd, 2);
    if(ret != 0) return 0;
    
    cmd[0] = 0x03;
    i2c->write(hmc_addr, cmd, 1);
    i2c->read(hmc_addr | 0x01, data.reg, 6, true);
    
    // データのHとLが逆に読み込まれているのでスワップする
    for(int i=0; i<3; i++) {
        char temp = 0;
        temp = data.reg[i*2];
        data.reg[i*2] = data.reg[i*2+1];
        data.reg[i*2+1] = temp;
    }
    
    // 軸を加速度センサーとあわせる
    int16_t temp = data.value[1];
    data.value[1] = data.value[2];
    data.value[2] = temp;
    
    temp = data.value[1];
    data.value[1] = -data.value[0];
    data.value[0] = temp;
    
    
    return 1;
}