#include "mbed.h"
#include "MQTTEthernet.h"
#include "MQTTClient.h"
#include "MbedJSONValue.h"
#include <string>
#include "rtos.h"
#include "FXOS8700Q.h"

I2C i2c(PTE25, PTE24);

FXOS8700QAccelerometer acc(i2c, FXOS8700CQ_SLAVE_ADDR1);
FXOS8700QMagnetometer mag(i2c, FXOS8700CQ_SLAVE_ADDR1);
motion_data_units_t acc_data, mag_data;

DigitalOut red(LED_RED);
DigitalOut green(LED_GREEN);
DigitalOut blue(LED_BLUE);
DigitalOut r1(PTB2);
DigitalOut r2(PTB3);
PwmOut led(PTD1);
InterruptIn sw_left(SW3);
InterruptIn sw_right(SW2);

#define API_KEY         "7553e4b7-0930-4b72-b392-890ef25bde0a"
#define PROJECT_ID      "5882"
#define DEVICE_UUID     "ef51c7bf-105a-408d-ac63-c403d15f7668"              

// Publishing topics
char* pubTopic_acc_x      = "/a/"API_KEY"/p/"PROJECT_ID"/d/"DEVICE_UUID"/sensor/Accelerometer_X/data";
char* pubTopic_acc_y      = "/a/"API_KEY"/p/"PROJECT_ID"/d/"DEVICE_UUID"/sensor/Accelerometer_Y/data";
char* pubTopic_acc_z      = "/a/"API_KEY"/p/"PROJECT_ID"/d/"DEVICE_UUID"/sensor/Accelerometer_Z/data";

char* pubTopic_mag_x      = "/a/"API_KEY"/p/"PROJECT_ID"/d/"DEVICE_UUID"/sensor/Magnetometer_X/data";
char* pubTopic_mag_y      = "/a/"API_KEY"/p/"PROJECT_ID"/d/"DEVICE_UUID"/sensor/Magnetometer_Y/data";
char* pubTopic_mag_z      = "/a/"API_KEY"/p/"PROJECT_ID"/d/"DEVICE_UUID"/sensor/Magnetometer_Z/data";

char* pubTopic_sw_left      = "/a/"API_KEY"/p/"PROJECT_ID"/d/"DEVICE_UUID"/sensor/Button_left/data";
char* pubTopic_sw_right      = "/a/"API_KEY"/p/"PROJECT_ID"/d/"DEVICE_UUID"/sensor/Button_right/data";

// Subscription topics
char* subTopic_RLED    = "/a/"API_KEY"/p/"PROJECT_ID"/d/"DEVICE_UUID"/actuator/Red/state";
char* subTopic_GLED    = "/a/"API_KEY"/p/"PROJECT_ID"/d/"DEVICE_UUID"/actuator/Green/state";
char* subTopic_BLED    = "/a/"API_KEY"/p/"PROJECT_ID"/d/"DEVICE_UUID"/actuator/Blue/state";

char* subTopic_Relay1 = "/a/"API_KEY"/p/"PROJECT_ID"/d/"DEVICE_UUID"/actuator/Relay_1/state";
char* subTopic_Relay2 = "/a/"API_KEY"/p/"PROJECT_ID"/d/"DEVICE_UUID"/actuator/Relay_2/state";

char* subTopic_LED     = "/a/"API_KEY"/p/"PROJECT_ID"/d/"DEVICE_UUID"/actuator/LED/state";

int send = 0;
int pressed_left = 0;
int pressed_right = 0;
int state_left = 0;
int state_right = 0;

MbedJSONValue JSON;
std::string value;

void readSensors_thread(void const *args) {
    while(true) {
        Thread::wait(5000);
        
        // unit based results
        acc.getAxis(acc_data);
        mag.getAxis(mag_data);
        //printf("ACC: X=%1.4ff Y=%1.4ff Z=%1.4ff \t MAG: X=%4.1ff Y=%4.1ff Z=%4.1ff\r\n", acc_data.x, acc_data.y, acc_data.z, mag_data.x, mag_data.y, mag_data.z);
        
        send = 1;
    }
}
void messageArrived_RLED(MQTT::MessageData& md)
{
    char *message = (char *)malloc(md.message.payloadlen);
    int state = 0;
    MbedJSONValue dhMessage;
    memcpy(message, md.message.payload, md.message.payloadlen);
    // printf("message: %s\n", message);
    
    parse(dhMessage, message);
    state = atoi(dhMessage["state"].get<std::string>().c_str());
    // printf("state: %d\n", state);
    
    red = !state;
    
    free(message);
}

void messageArrived_GLED(MQTT::MessageData& md)
{
    char *message = (char *)malloc(md.message.payloadlen);
    int state = 0;
    MbedJSONValue dhMessage;
    memcpy(message, md.message.payload, md.message.payloadlen);
    // printf("message: %s\n", message);
    
    parse(dhMessage, message);
    state = atoi(dhMessage["state"].get<std::string>().c_str());
    // printf("state: %d\n", state);
    
    green = !state;
    
    free(message);
}

void messageArrived_BLED(MQTT::MessageData& md)
{
    char *message = (char *)malloc(md.message.payloadlen);
    int state = 0;
    MbedJSONValue dhMessage;
    memcpy(message, md.message.payload, md.message.payloadlen);
    // printf("message: %s\n", message);
    
    parse(dhMessage, message);
    state = atoi(dhMessage["state"].get<std::string>().c_str());
    // printf("state: %d\n", state);
    
    blue = !state;
    
    free(message);
}

void messageArrived_LED(MQTT::MessageData& md)
{
    char *message = (char *)malloc(md.message.payloadlen);
    int state = 0;
    MbedJSONValue dhMessage;
    memcpy(message, md.message.payload, md.message.payloadlen);
    // printf("message: %s\n", message);
    
    parse(dhMessage, message);
    state = atoi(dhMessage["state"].get<std::string>().c_str());
    // printf("state: %d\n", state);
    
    led = state/100.0f;
    
    free(message);
}

void messageArrived_Relay1(MQTT::MessageData& md)
{
    char *message = (char *)malloc(md.message.payloadlen);
    int state = 0;
    MbedJSONValue dhMessage;
    memcpy(message, md.message.payload, md.message.payloadlen);
    // printf("message: %s\n", message);
    
    parse(dhMessage, message);
    state = atoi(dhMessage["state"].get<std::string>().c_str());
    // printf("state: %d\n", state);
    
    r1 = !state;
    
    free(message);
}

void messageArrived_Relay2(MQTT::MessageData& md)
{
    char *message = (char *)malloc(md.message.payloadlen);
    int state = 0;
    MbedJSONValue dhMessage;
    memcpy(message, md.message.payload, md.message.payloadlen);
     printf("message: %s\n", message);
    
    parse(dhMessage, message);
    state = atoi(dhMessage["state"].get<std::string>().c_str());
     printf("state: %d\n", state);
    
    r2 = !state;
    
    free(message);
}

void sw_left_release(void)
{
    state_left = !state_left;
    pressed_left = 1;
}

void sw_right_release(void)
{
     state_right = !state_right;
     pressed_right = 1;   
}

int main()
{
    red = 1;
    green = 1;
    blue = 1;
    r1 = 1;
    r2 = 1;
    led = 0;
    
    printf("Hello Freedom :)\n");
    MQTTEthernet ipstack = MQTTEthernet();

    MQTT::Client<MQTTEthernet, Countdown> client = MQTT::Client<MQTTEthernet, Countdown>(ipstack);
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;

    /* set connect info */
    char *hostname  = "mqtt.devicehub.net";
    char *username = NULL;
    char *password = NULL;
    int r = rand() % 100;
    char buf_client[10] = {0};
    sprintf(buf_client, "K64F-%d", r);
    char *clientID = buf_client;
    int  port = 1883;

    data.username.cstring = username ;
    data.password.cstring = password ;
    data.clientID.cstring = clientID ;
    
    // Set publish info
    MQTT::Message message;
    message.qos = MQTT::QOS0;
    message.retained = true;
    message.dup = false;
    
    int rc = ipstack.connect(hostname, port, NULL);
    if (rc != 0){
        printf("rc from TCP connect is %d\r\n", rc);
        NVIC_SystemReset();
    }

    if ((rc = client.connect(data)) != 0){
        printf("rc from MQTT connect is %d\r\n", rc);
        NVIC_SystemReset();
    }
    printf("MQTT connected\r\n");
    
    client.subscribe(subTopic_RLED, MQTT::QOS0, messageArrived_RLED);
    client.subscribe(subTopic_GLED, MQTT::QOS0, messageArrived_GLED);
    client.subscribe(subTopic_BLED, MQTT::QOS0, messageArrived_BLED);
    client.subscribe(subTopic_LED, MQTT::QOS0, messageArrived_LED);
    client.subscribe(subTopic_Relay1, MQTT::QOS0, messageArrived_Relay1);
    client.subscribe(subTopic_Relay2, MQTT::QOS0, messageArrived_Relay2);
    
    printf("Subscribed to MQTT topics\r\n");
    
    acc.enable();
    mag.enable();
    
    sw_left.rise(&sw_left_release);
    sw_right.rise(&sw_right_release);
    Thread thread(readSensors_thread);
    
    while(true) {
        client.yield(100);
        
        if(send){
            JSON["value"] = acc_data.x;
            value = JSON.serialize();
            message.payload = (void*)value.c_str();
            message.payloadlen = strlen(value.c_str());
            client.publish(pubTopic_acc_x, message);
            
            JSON["value"] = acc_data.y;
            value = JSON.serialize();
            message.payload = (void*)value.c_str();
            message.payloadlen = strlen(value.c_str());
            client.publish(pubTopic_acc_y, message);
            
            JSON["value"] = acc_data.z;
            value = JSON.serialize();
            message.payload = (void*)value.c_str();
            message.payloadlen = strlen(value.c_str());
            client.publish(pubTopic_acc_z, message);
            
            JSON["value"] = mag_data.x;
            value = JSON.serialize();
            message.payload = (void*)value.c_str();
            message.payloadlen = strlen(value.c_str());
            client.publish(pubTopic_mag_x, message);
            
            JSON["value"] = mag_data.y;
            value = JSON.serialize();
            message.payload = (void*)value.c_str();
            message.payloadlen = strlen(value.c_str());
            client.publish(pubTopic_mag_y, message);
            
            JSON["value"] = mag_data.z;
            value = JSON.serialize();
            message.payload = (void*)value.c_str();
            message.payloadlen = strlen(value.c_str());
            client.publish(pubTopic_mag_z, message);
            
            send = 0;  
        }
        
        if(pressed_left){
            JSON["value"] = state_left;
            value = JSON.serialize();
            message.payload = (void*)value.c_str();
            message.payloadlen = strlen(value.c_str());
            client.publish(pubTopic_sw_left, message);
            
            pressed_left = 0;
        }
        
        if(pressed_right){
            JSON["value"] = state_right;
            value = JSON.serialize();
            message.payload = (void*)value.c_str();
            message.payloadlen = strlen(value.c_str());
            client.publish(pubTopic_sw_right, message);
            
            pressed_right = 0;
        }
    };
}
