#include "mbed.h"
#include "EthernetInterface.h"

#define MEGA               (1024*1024)
#define BUFFER_SIZE        1024
#define NUMBER_OF_SECONDS (20*1000u)  // 20 seconds

#define REMOTE_IP       "192.168.100.2"
#define REMOTE_PORT      2327
#define NUMBER_OF_FRAMES 1000

struct UDPStat
{
    int BytesReceived;
    int FramesReceived;
    int LostPackets;
};

struct UDPStat UDP_Statistics;

int main() {

    EthernetInterface eth;
    eth.init();
    eth.connect();
    
    printf("Started UDP Fast Test...\n");
    
    UDPSocket server;
    Endpoint endp;
    
    printf("Remote endpoint @ %s:%d\n",REMOTE_IP,REMOTE_PORT);
    endp.set_address(REMOTE_IP,REMOTE_PORT);
    
    printf("Binding result :%d\n", server.bind(REMOTE_PORT));
    
    server.set_blocking(false,1000);
    char buffer[BUFFER_SIZE];
    
    while(true)
    {
        unsigned int time = PICO_TIME_MS();
        int index = -1;
        
        memset(&UDP_Statistics,0x0,sizeof(struct UDPStat));
        while( (time + NUMBER_OF_SECONDS) >= (unsigned int)PICO_TIME_MS())
        {
            int size;
            size = server.receiveFrom(endp,buffer,sizeof(buffer));
            if(size > 0)
            {
                int _index;
                UDP_Statistics.BytesReceived += size;
                UDP_Statistics.FramesReceived++;
                _index = *((int *)buffer);
                
                if(index>0)
                {
                    UDP_Statistics.LostPackets+= _index-index-1;
                }
                index = _index;
            }
        }
        time = PICO_TIME_MS() - time;
        time = time/1000;
        
        printf("20 seconds Rx statistics\n");
        printf("Total bytes received : %d\n",UDP_Statistics.BytesReceived);
        printf("UDP Speed :%.3f Mbit/s\n",(UDP_Statistics.BytesReceived *8.0)/(20.0*MEGA));
        printf("Loss percentage: %.2f %%\n\n\n",(UDP_Statistics.LostPackets*100.0)/(UDP_Statistics.LostPackets+UDP_Statistics.FramesReceived));
    }
    
    server.close();
}
