#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"

#define ECHO_SERVER_PORT 7
#define UDP_SERVER_PORT  2327
#define BUFFER_QUANTITY   (1024*1024)
#define NUMBER_OF_THREADS   2u

Queue<void,NUMBER_OF_THREADS> clientList;


/****** UDP Connection ******/
void UDPThread(const void * arg);
void startUDPThread(void)
{
    Thread * threadUDPEcho = new Thread(UDPThread);
}

// thread is sending out data on a rate of 1KB at each 10ms
void UDPThread(const void * arg)
{

    UDPSocket server;
    Endpoint endp;
    char buffer[1024];

    endp.set_address("255.255.255.255",UDP_SERVER_PORT);
    printf("Binding result :%d\n", server.bind(UDP_SERVER_PORT));

    server.set_blocking(false,1500);
    printf("Started UDP Broadcast server...\n");
    server.set_broadcasting();
    
    while(true)
    {
            server.sendTo(endp,buffer,sizeof(buffer));
            Thread::wait(10);
    }
    
    server.close();
}

/****** TCP Connection ******/

void TCPClientThread(const void * arg);
void acceptNewClient(TCPSocketServer & server)
{
    TCPSocketConnection *client =new TCPSocketConnection();
    server.accept(*client);
    client->set_blocking(false, 1500); // Timeout after (1.5)s
    printf("Connection from: %s\n", client->get_address());
    if(clientList.put((void *)client) != osOK) // queue is full?
        delete(client);
}

void TCPClientThread(const void * arg)
{

    while(true)
    {
        TCPSocketConnection * client = NULL;
        char buffer[1024];
        int dataReceived = 0;
        int dataSent = 0;
        
        // client stream
        osEvent evt = clientList.get();
        if(evt.status == osEventMessage)
            client = (TCPSocketConnection *)evt.value.p;
         else 
            continue;
        
        while(true)
        {
            printf("\n\n\nStarting the receiving part...\n");
            while(dataReceived < BUFFER_QUANTITY)
            {
                int n = client->receive(buffer, sizeof(buffer));
                if (n <= 0) {
                    printf("Receive error\n");
                    break;
                }
                dataReceived += n;
            }
            
           
            printf("Received : %d bytes\nExpected : %d bytes\n",dataReceived,BUFFER_QUANTITY);
            if(dataReceived < BUFFER_QUANTITY)
            {
                printf("Receiving part of the test has failed. Exiting connection.\n");
                break;
            }
            else{
                printf("Receiving has passed...\n");
            }
            
            printf("\n\n\nStarting the sending part...\n");
            while(dataSent < BUFFER_QUANTITY)
            {
                int n = client->send_all(buffer, sizeof(buffer));
                if (n <= 0) {
                    printf("Send error : %d\n",n);
                    break;
                }
                dataSent += n;
            }
            
            printf("Sent : %d bytes\nExpected : %d bytes\n",dataSent,BUFFER_QUANTITY);
            if(dataSent < BUFFER_QUANTITY)
            {
                printf("Sending part of the test has failed. Exiting connection.\n");
                break;
            }
            else
            {
                printf("Sending test has passed...\n");
            }
            
            
            printf("\n\n\nStarting echo part...\n");
            dataReceived = dataSent = 0;
            while((dataReceived+dataSent) < 2*BUFFER_QUANTITY)
            {
                int n = client->receive(buffer, sizeof(buffer));
                if (n <= 0) {
                    printf("Receive error\n");
                    break;
                }
                dataReceived += n;
                
                n = client->send_all(buffer, n);
                if (n <= 0) {
                    printf("Send error\n");
                    break;
                }
                dataSent += n;
            }
            
            printf("Echo size : %d bytes\nExpected : %d bytes\n",(dataReceived+dataSent),2*BUFFER_QUANTITY);
            if((dataReceived+dataSent) < 2*BUFFER_QUANTITY)
            {
                printf("Echo test has failed.Exiting connection...\n");
            }
            else
            {
                printf("Echo test has passed...\n");
            }
            
            
            printf("Test was finished...\n");
        }
        // droping out client
        client->close();
        delete(client);
        break;
     }
}

int main() 
{
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address %s\n", eth.getIPAddress());
    
    // startUDP Thread
    startUDPThread();
    
    
    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();
    // start client threads
    for(int i=0;i<NUMBER_OF_THREADS;i++)
    {
        new Thread(TCPClientThread);
    }
    printf("Started TCP server...\n");

    while (true) 
    {
        acceptNewClient(server);
    }
}
