#include <mbed.h>
#include <stdarg.h>
#include "EthernetInterface.h"

#define ECHO_SERVER_PORT        7
#define BUFFER_QUANTITY        (1024*1024)
#define MAX_NUMBER_OF_RETRIES  (10u)


int main() {
    
    printf("Socket exchange data forever...\n");    
    
    EthernetInterface eth;
    int connections = 0;
    eth.init(); //Use DHCP
    eth.connect();
    //printf("IP Address %s\n", eth.getIPAddress());
    
    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();
    
    while (true) {
    printf("\nWait for new connection...\n");
    printf("Client number %d\n",++connections);
    TCPSocketConnection client;
    server.accept(client);
    client.set_blocking(false, 2500); // Timeout after (1.5)s
    printf("Connection from: %s\n", client.get_address());
    char buffer[1024];
    while (true) {
        int retries = 0;
        int dataReceived = 0;
        int dataSent = 0;
        
        printf("\n\n\nStarting the receiving part...\n");
        while(dataReceived < BUFFER_QUANTITY)
        {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) {
                printf("Receive error\n");
                retries++;
                if(retries >= MAX_NUMBER_OF_RETRIES)
                    break;
            }
            dataReceived += n;
        }
        
       
        printf("Received : %d bytes\nExpected : %d bytes\n",dataReceived,BUFFER_QUANTITY);
        if(dataReceived < BUFFER_QUANTITY)
        {
            printf("Receiving part of the test has failed. Exiting connection.\n");
            break;
        }
        else{
            printf("Receiving has passed...\n");
        }
        
        printf("\n\n\nStarting the sending part...\n");
        retries = 0;
        while(dataSent < BUFFER_QUANTITY)
        {
            int n = client.send_all(buffer, sizeof(buffer));
            if (n <= 0) {
                printf("Send error\n");
                retries++;
                if(retries >= MAX_NUMBER_OF_RETRIES)
                    break;
            }
            dataSent += n;
        }
        
        printf("Sent : %d bytes\nExpected : %d bytes\n",dataSent,BUFFER_QUANTITY);
        if(dataSent < BUFFER_QUANTITY)
        {
            printf("Sending part of the test has failed. Exiting connection.\n");
            break;
        }
        else
        {
            printf("Sending test has passed...\n");
        }
        
        
        printf("\n\n\nStarting echo part...\n");
        dataReceived = dataSent = 0;

        while((dataReceived+dataSent) < 2*BUFFER_QUANTITY)
        {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) {
                printf("Receive error\n");
            }
            dataReceived += n;
            
            n = client.send_all(buffer, n);
            if (n <= 0) {
                printf("Send error, returned 0\n");
                break;
            }
            dataSent += n;
        }
        
        printf("Echo size : %d bytes\nExpected : %d bytes\n",(dataReceived+dataSent),2*BUFFER_QUANTITY);
        if((dataReceived+dataSent) < 2*BUFFER_QUANTITY)
        {
            printf("Echo test has failed.Exiting connection...\n");
            break;
        }
     }
     
    client.close();
    printf("Test was finished...\n");
    
  }
  
  return 0;
}
