#include <mbed.h>
#include <stdarg.h>
#include "EthernetInterface.h"

#define ECHO_SERVER_PORT  7
#define BUFFER_QUANTITY   (1024*1024)
#define BUFFER_SIZE       (1024)


EthernetInterface eth;

int main() 
{
    TCPSocketServer server;
   
    printf("Started PicoTCP Tx Benchmark....\n");
    
    eth.init();
    printf("Waiting for DHCP server to give IP...\n");
    
    while(eth.connect() != 0);
    printf("IP address assigned : %s\n",eth.getIPAddress());
    
    server.bind(ECHO_SERVER_PORT);
    server.listen();
    printf("Local server listening on port : %d\n",ECHO_SERVER_PORT);
    
    
    while (true) {
        printf("\n>>> You can start PicoTCP_Official_TCP_Tx_Benchmark.py\n");    
        
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 1500); // Timeout after (1.5)s
        
        char buffer[BUFFER_SIZE];
        int dataSent = 0;
        while(dataSent < BUFFER_QUANTITY)
        {
            int n = client.send_all(buffer, sizeof(buffer));
            if (n <= 0) {
                break;
            }
            dataSent += n;
        }
    
        if(dataSent == BUFFER_QUANTITY)
        {
            printf("You can read the Tx Throughput now \n");
        }
        else
        {
            printf("Benchmark failed !\n");
        }
    }    
}
