
#include <mbed.h>
#include <stdarg.h>
#include "EthernetInterface.h"

#define ECHO_SERVER_PORT  7
#define BUFFER_QUANTITY   (1024*1024)
#define BUFFER_SIZE       (1024)


EthernetInterface eth;

int main() 
{
    TCPSocketServer server;
   
    printf("Started PicoTCP Rx Benchmark....\n");
    
    eth.init();
    printf("Waiting for DHCP server to give IP...\n");
    
    while(eth.connect() != 0);
    printf("IP address assigned : %s\n",eth.getIPAddress());
    
    server.bind(ECHO_SERVER_PORT);
    server.listen();
    printf("Local server listening on port : %d\n",ECHO_SERVER_PORT);
    
    
    while (true) {
        printf("\n>>> You can start PicoTCP_Official_TCP_Rx_Benchmark.py\n");    
        
        TCPSocketConnection client;
        uint32_t startTime, stopTime;
        server.accept(client);
        client.set_blocking(false, 1500); // Timeout after (1.5)s
        
        char buffer[BUFFER_SIZE];
        int dataReceived = 0;
        
        startTime = PICO_TIME_MS();
        while(dataReceived < BUFFER_QUANTITY)
        {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) {
                break;
            }
            dataReceived += n;
        }
        stopTime = PICO_TIME_MS();
        
        if(dataReceived == BUFFER_QUANTITY)
        {
            printf("PicoTCP Rx Throughput is : %.3f Mbit/s\n" , (float)((BUFFER_QUANTITY*8.0)/(1000*(stopTime - startTime))));
        }
        else
        {
            printf("Benchmark failed !\n");
        }
    }    
}
