#include "mbed.h"
#include "ultrasonic.h"

Serial pc(USBTX, USBRX);
Serial esp(PC_10, PC_11); // tx, rx 
DigitalOut myled(LED1);

Timer t;

int  count,ended,timeout;
float globaldist;
char buf[1024];
char sendbuf[255];
char snd[255];

float dist0 =  11.0;                        // Abstand Ultraschallsensor zur vollen Oberfläche [cm]
float iLeng = 147.0;                        // Länge des Wassertanks [cm]
float iBrei =  67.0;                        // Breite des Wassertanks [cm]
float iHoeh = 140.0;                        // Höhe des Wassertanks [cm]
int maximumRange = 200;                   // Maximum Messbereich 200 cm
int minimumRange = 0;                     // Minimum Messbereich   0 cm
unsigned int numsamples = 0, avgsamples=99; // Mittelung über 100 Abstandsmessungen
int avgsamplesarr[100];

                                          // Volumen Füllstand [l] des vollen Tanks
float volmax = iLeng * iBrei * iHoeh / 1000.0;
float volakt;                             // aktueller Füllstand [m3]

void SendCMD(),getreply(),ESPconfig(),ESPsetbaudrate();
float median(int n, int x[]);

 void dist(int distance)
{
    //put code here to happen when the distance is changed
    
    if (numsamples < avgsamples) {
        avgsamplesarr[numsamples] = distance/10;
        printf("Distance changed to %dmm\r\n", distance);
        numsamples++;
        }
    
    /*    
    globaldist = distance/10; // convert distance from mm to cm
    printf("Distance changed to %dcm\r\n", globaldist);
    
    if ((globaldist<(iHoeh+dist0)) && (globaldist >= dist0)) {
        // gemessene Entfernung ist kleiner als Abstand zum Boden des Tanks
        // und gemessene Entfernung ist größer als Überlauf
        volakt = (iHoeh + dist0 - globaldist) * iLeng * iBrei / 1000.0;
    } else {
        volakt = -1;
    }
    */    
    
}

ultrasonic mu(PC_0, PC_1, .1, 1, &dist);    //Set the trigger pin to PC_0 and the echo pin to PC_1
                                        //have updates every .1 seconds and a timeout after 1
                                        //second, and call dist when the distance changes

int main()
{
    pc.baud(115200);
    esp.baud(115200);   // change this to the new ESP8266 baudrate if it is changed at any time.    
        
    while(1)
    {
        mu.startUpdates();//start mesuring the distance
        while(numsamples<avgsamples)
        {
            mu.checkDistance();     //call checkDistance() as much as possible, as this is where
                                    //the class checks if dist needs to be called.
            wait(0.01);
        }
        //mu.pauseUpdates(); //stop measure
        
        globaldist = median(100,avgsamplesarr);
        pc.printf("Median ist %f\r\n",globaldist);
        
        if ((globaldist<(iHoeh+dist0)) && (globaldist >= dist0)) {
            // gemessene Entfernung ist kleiner als Abstand zum Boden des Tanks
            // und gemessene Entfernung ist größer als Überlauf
            volakt = (iHoeh + dist0 - globaldist) * iLeng * iBrei / 1000.0;
        } else {
            volakt = -1;
        }
        
        numsamples = 0;
        
        strcpy(snd,"AT+CIPSTART=\"TCP\",\"192.168.3.60\",7072\r\n");
        SendCMD();
        timeout=2;
        getreply();
        pc.printf(buf);
        
        //AT+CIPSEND=<length>;
        //sprintf(buf,"setreading wassertank state %d\r\n",globaldist);
        sprintf(sendbuf,"setreading wassertank state D:%fcm V:%fm3\r\n\0",globaldist,volakt);
        
        sprintf(snd,"AT+CIPSEND=%d\r\n",strlen(sendbuf));
        //pc.printf(snd);
        SendCMD();
        timeout=2;
        getreply();
        pc.printf(buf);
        
        strcpy(snd,sendbuf);
        pc.printf(snd);
        SendCMD();
        timeout=2;
        getreply();
        pc.printf(buf);
        
        strcpy(snd,"AT+CIPCLOSE\r\n");
        SendCMD();
        timeout=2;
        getreply();
        pc.printf(buf);
        
        wait(10);
    }
}


void SendCMD()
{    
    esp.printf("%s", snd);    
} 

void getreply()
{    
    memset(buf, '\0', sizeof(buf));
    t.start();
    ended=0;count=0;
    while(!ended) {
        if(esp.readable()) {
            buf[count] = esp.getc();count++;
            }
        if(t.read() > timeout) {
                ended = 1;t.stop();t.reset();
            }
        }   
}     

float median(int n, int x[]) {
    float temp;
    int i, j;
    // the following two loops sort the array x in ascending order
    for(i=0; i<n-1; i++) {
        for(j=i+1; j<n; j++) {
            if(x[j] < x[i]) {
                // swap elements
                temp = x[i];
                x[i] = x[j];
                x[j] = temp;
            }
        }
    }

    if(n%2==0) {
        // if there is an even number of elements, return mean of the two elements in the middle
        return((x[n/2] + x[n/2 - 1]) / 2.0);
    } else {
        // else return the element in the middle
        return x[n/2];
    }
}