#include "mbed.h"
#include "MMA8451Q.h"
#include "BLEDevice.h"

#define MMA8451_I2C_ADDRESS (0x1C<<1)

#define NEED_CONSOLE_OUTPUT 1 /* Set this if you need debug messages on the console;
                               * it will have an impact on code-size and power consumption. */

#if NEED_CONSOLE_OUTPUT
Serial  pc(USBTX, USBRX);
#define DEBUG(...) { pc.printf(__VA_ARGS__); }
#else
#define DEBUG(...) /* nothing */
#endif /* #if NEED_CONSOLE_OUTPUT */

PinName const SDA = p22;
PinName const SCL = p20;
MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);

//Serial pc(USBTX, USBRX);
Ticker ticker;
Ticker ticker2;
    
InterruptIn button(p1);
    
const static char  DEVICE_NAME[] = "HRM1017_SPEED";
static volatile bool  triggerSensorPolling = false;
BLEDevice  ble;

/* Health Thermometer Service */ 
uint8_t             thermTempPayload[5] = { 0, 0, 0, 0, 0 };
GattCharacteristic  tempChar (GattCharacteristic::UUID_TEMPERATURE_MEASUREMENT_CHAR, thermTempPayload, 5, 5, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_INDICATE);
GattCharacteristic *htmChars[] = {&tempChar, };
GattService         htmService(GattService::UUID_HEALTH_THERMOMETER_SERVICE, htmChars, sizeof(htmChars) / sizeof(GattCharacteristic *));
uint16_t            uuid16_list[] = {GattService::UUID_HEALTH_THERMOMETER_SERVICE};

static Gap::ConnectionParams_t connectionParams;

void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)    // Mod
{
    DEBUG("Disconnected handle %u, reason %u\n", handle, reason);
    DEBUG("Restarting the advertising process\n\r");
    ble.startAdvertising();
}

void onConnectionCallback(Gap::Handle_t handle, const Gap::ConnectionParams_t *params)   //Mod
{
    DEBUG("connected. Got handle %u\r\n", handle);
    connectionParams.slaveLatency = 1;
    if (ble.updateConnectionParams(handle, &connectionParams) != BLE_ERROR_NONE) {
        DEBUG("failed to update connection paramter\r\n");
    }
}
void GetAccelterData( void );
void periodicCallback(void)
{
    GetAccelterData();
    triggerSensorPolling = true;
}


void initBLE( void )
{
    ticker.attach_us(periodicCallback, 10000); //10msecの周期タイマー

    ble.init();
    DEBUG("Init done\n");
    ble.onDisconnection(disconnectionCallback);
    ble.onConnection(onConnectionCallback);

    ble.getPreferredConnectionParams(&connectionParams);

    /* setup advertising */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t*)uuid16_list, sizeof(uuid16_list));

    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.setAdvertisingInterval(160); /* 100ms; in multiples of 0.625ms. */     //Advertisingの周期時間 0.625msec単位
    ble.startAdvertising();

    DEBUG("Start Advertising\n");

    ble.addService(htmService);

}
//-------------------------------------

float oxyz = 0;
float dxyz = 0;

bool f=1;
float velocity = 0;
float maxvelocity = 0;
void GetAccelterData( void )
{
    float x = acc.getAccX();
    float y = acc.getAccY();
    float z = acc.getAccZ();
    float xyz = sqrt(x*x+y*y+z*z);

    if(f==0){
        dxyz += xyz - oxyz;
    }
    f=0;
    velocity = dxyz*9.8;
    velocity *= (3600.0f/1000.0f/10.0f);
    oxyz = xyz;

    pc.printf("X: %7.2f, Y: %7.2f, Z: %7.2f   v:%7.2f\r\n", x, y, z, velocity);

    if (maxvelocity < velocity){
        maxvelocity = velocity;
    }
}
void InitAccelterData( void )
{
    DEBUG("MMA8451 ID: %d\r\n", acc.getWhoAmI());
 }
void onButton( void )
{
    DEBUG("#####\r\n");
    dxyz=0;
    maxvelocity = 0;
}

void updateServiceValues(void);

int main(void) {
#if NEED_CONSOLE_OUTPUT
    pc.baud(115200);
#endif
 
    button.rise(&onButton);
 
    InitAccelterData();
    initBLE();

    while (true) {
        if (triggerSensorPolling) {
            triggerSensorPolling = false;
            updateServiceValues();
        } else {
            ble.waitForEvent();
        }
    }
}

uint32_t quick_ieee11073_from_float(float temperature)
{
    uint8_t  exponent = 0xFF; //exponent is -1
    uint32_t mantissa = (uint32_t)(temperature*10);
    
    return ( ((uint32_t)exponent) << 24) | mantissa;
}

void updateServiceValues(void)
{
      uint32_t temp_ieee11073 = quick_ieee11073_from_float(maxvelocity);
      memcpy(thermTempPayload+1, &temp_ieee11073, 4);
      ble.updateCharacteristicValue(tempChar.getValueAttribute().getHandle(), thermTempPayload, sizeof(thermTempPayload));  //Mod
}




