#include "mbed.h"
#include "PololuLedStrip.h"
#include <iostream>

#define LED_COUNT 60

Serial pc(USBTX, USBRX); // tx, rx

PololuLedStrip ledStrip(p11);

rgb_color colors[LED_COUNT];

Timer timer;

int aMajor[6] = {0,2,2,2,0,-1};
int bMajor[6] = {2,4,4,4,2,-1};
int cMajor[6] = {0,1,0,2,3,-1};
int dMajor[6] = {2,3,2,0,-1,-1};
int eMajor[6] = {0,0,1,2,2,0};
int fMajor[6] = {1,-1,2,3,3,1};
int gMajor[6] = {3,0,0,0,2,3};

int aMinor[6] = {0,1,2,2,0,-1};
int bMinor[6] = {2,3,4,4,2,-1};
int cMinor[6] = {3,4,5,5,3,-1};
int dMinor[6] = {1,3,2,0,-1,-1};
int eMinor[6] = {0,0,0,2,2,0};
int fMinor[6] = {1,1,1,3,3,1};
int gMinor[6] = {-1,-1,-1,-1,0,0};
int gMinorActual[6] = {3,3,3,5,5,3};

int aSharpMajor[6] = {1,3,3,3,1,-1};
int cSharpMajor[6] = {1,2,1,3,4,-1};
int fSharpMajor[6] = {2,-1,3,4,4,2};
int gSharpMajor[6] = {4,1,1,1,3,4};

int aSharpMinor[6] = {1,2,3,3,1,-1};
int fSharpMinor[6] = {2,2,2,4,4,2};

/* 
   Above are the various arrays which represent the location of the string
   played in a given fret to achieve a certain chord. The layout
   of this arrangement helps the mBed light up the correct pattern
   of LEDs on the LED strip. Not all of the chords can be played as the
   Solo only includes the first six frets.
*/

int chordCode = 0;
int testResult = 0;
int interpretedChordCode = 0;

using namespace std;

int ledMapping(int fret, int str)
{
    int result;
    // Initialise a variable that represents the specific number of the LED
    // that is to be lit up
    if(fret != -1)
    {
    if(fret%2 != 0)
    // If the fret number is odd...
    {
        result = 6*fret + str - 1;
        // ...then the LED number for that fret corresponds to the above formula
    } else
    // Otherwise if the fret number is even...
    {
        result = 6*(fret + 1) - str;
        // ...then the LED number for that fret corresponds to the above formula
    }
    return result;
    }
    return -1;
    // Output the LED number as a return value so that other parts of the code can
    // use it when this function is called for a specific chord.
}

/*
 * The decoder takes a char value that represents a chord, whether it is sharp or natural and whether
 * it is major or minor. The inputted value for chord is either a capital (major) or lowercase letter (minor).
 * Also assigned is a sharp value (either 0 or 1, where 0 is a natural note and 1 is a sharp)
 */

int decoder(string typed)
{
        int ascii = int(typed[0]);
        // Convert the first character in the array 's' and find its
        // hexadecimal code as a reference
        int chordValue;
        // Initialise a variable associated with the result so we can
        // assess it later
        if (65 <= ascii && ascii <= 71)
        // If its hexadecimal number corresponds to a uppercase letter
        // such that it is a major chord and...
        {
            if (typed.size() == 1)
            // ...if the input is only one letter/symbol...
            {
                chordValue = ascii - 65;
                // ...then offset the hexadecimal code of that letter by 65
                // to map it back to the original list of non-sharp major chords and
                // store that value.
            }
            else
            // ...if the input is more than one letter/symbol then assume
            // a hash (#) was entered to indicate a sharp value so...
            {
                chordValue = ascii - 51;
                // ...offset the hexadecimal code by 51 to map it back to
                // the original list of sharp major chords and store that value.
            }
        }
        else if (97 <= ascii && ascii <= 103)
        // If its hexadecimal number corresponds to a lowercase letter
        // such that it is a minor chord and...
        {
            if (typed.size() == 1)
            // ...if the input is only one letter/symbol...
            {
                chordValue = ascii - 90;
                // ...then offset the hexadecimal code by 90 to map it back to
                // the original list of non-sharp minor chords and store that value.
            }
            else
            // ...if the input is more than one letter/symbol then assume
            // a hash (#) was entered to indicate a sharp value so...
            {
                chordValue = ascii - 76;
                // ...offset the hexadecimal code by 51 to map it back to
                // the original list of sharp minor chords and store that value.
            }
        } 
        else
        // If the typed character does not correspond to an existing chord then...
        {
            pc.printf("Incorrect input\n");
            // Output an error message that indicates an incorrect input by the
            // user and...
            return(-99);
            // ...output -99 to indicate an error has occured to other parts of
            // the code.
        }
        
        if (typed.size() > 2)
        // If the user input is greater than two characters then...
        {
            pc.printf("Incorrect input\n");
            // Output an error message that indicates an incorrect input by the
            // user and...
            return(-99);
            // ...output -99 to indicate an error has occured to other parts of
            // the code. 
        }
        
        if (chordValue != 15 && chordValue != 17 && chordValue != 18 && chordValue != 22 && chordValue != 23 && chordValue != 24 && chordValue != 25 && chordValue != 27)
        // If the obtained chord value corresponds to a chord that can actually be
        // played by Solo then...
        {
             return chordValue;
             // ...output that chord value
         }
         else
         // If the chord value corresponds to a chord that cannot be played by Solo or 
         // is not even in the original table of chords then...
         {
             pc.printf("This chord will not be played by the Solo\n");
             // Output an error message that indicates a chord that cannot be played by the
             // Solo and...
             return -1;
             // ...output -1 to indicate an error with the input
         }
}

void illuminator (int position, int colour)
{
     //pc.printf ("Position: %d Colour: %d\n",position,colour);
     if (position != -1)
     {
         if (colour == -1)
         {
            colors[position] = (rgb_color){40,0,0};
         }
         else if (colour == 0)
         {
            colors[position] = (rgb_color){40,40,40};
         }
         else if (colour == 1)
         {
            colors[position] = (rgb_color){0,40,0};
         }
         else
         {
            pc.printf ("Error: invalid colour number in illuminator\n");
         }
    }
}

void feedback(int colour)
{
    if (colour == 1)
    {
        pc.printf("Great Job!\n");
    }
    else if (colour == 0)
    {
        pc.printf("Processing...\n");
    }
    else if (colour == -1)
    {
        pc.printf("You suck!\n");
    }
    else
    {
        pc.printf("Error: Colour input incorrect");
    }
}

void identifier(int shape)
{
    int list;
    // Initialise an integer variable 'result' that represents the list a chord belongs to.
    int position;
    // Initialise an integer variable 'position' that represents the chord's relative position
    // in its allocated list.
    const char* letter;
    // Intialise a character variable 'letter' that will store the letter of the chord (A to G)
    string type;
    // Initialise a string (sentence) variable 'type' that will store the type of the chord
    // e.g. "Sharp Minor" or "Major" etc.

    list = int(shape/7);
    // Set the value of the 'list' variable to correspond to the list to which
    // the chord (represented by 'shape') belongs to. Each list holds 7 chords
    // relating to the first 7 letters of the alphabet (A to G). Therefore the list
    // a chord originates from can be determined by interpreting the integer value
    // the chord rounds down to, when its value is divided by seven. For example...

    if (list == 0)
        // ...if the chord comes from list '0', then it must be...
    {
        type = "Major";
        // ... a Major chord.
    } else if (list == 1)
        // ...if the chord comes from list '1', then it must be...
    {
        type = "Minor";
        // ... a Minor chord.
    } else if (list == 2)
        // ...if the chord comes from list '2', then it must be...
    {
        type = "Sharp Major";
        // ... a Sharp Major chord.
    } else if (list == 3)
        // ...if the chord comes from list '3', then it must be...
    {
        type = "Sharp Minor";
        // ... a Sharp Minor chord.
    }

    position = 7*(list + 1) - shape;
    // Set the value of the 'position' as an indication of the position in the given list,
    // that is to say that higher chord values in the same list will have a lower
    // 'letter' due to the layout of the equation above. Irrespective of the list in
    // which it occurs...

    if (position == 1)
        // ...if the position value is 1, then it must be...
    {
        letter = "G";
        // ... a G chord.
    } else if (position == 2)
        // ...if the position value is 2, then it must be...
    {
        letter = "F";
        // ... an F chord.
    } else if (position == 3)
        // ...if the position value is 2, then it must be...
    {
        letter = "E";
        // ... an E chord.
    } else if (position == 4)
        // ...if the position value is 4, then it must be...
    {
        letter = "D";
        // ... a D chord.
    } else if (position == 5)
        // ...if the position value is 5, then it must be...
    {
        letter = "C";
        // ... a C chord.
    } else if (position == 6)
        // ...if the position value is 6, then it must be...
    {
        letter = "B";
        // ... a B chord.
    } else if (position == 7)
        // ...if the position value is 7, then it must be...
    {
        letter = "A";
        // ... an A chord.
    }
    pc.printf("%s %s\n",letter,type.c_str());
    // Output the letter of the chord, followed by its type separated by a
    // space such that the full name of the chord is displayed.
}
               
//TODO fix return values
//Change to a case/switch structure
int shaper (int shape, int colour) 
{
    if (shape == 0)
    {
        for(int i = 0; i<6; i++)
        {
            illuminator (ledMapping(aMajor[i],i+1), colour);
        }
        feedback(colour);
    }
    else if (shape == 1)
    {
        for(int i = 0; i<6; i++)
        {
            illuminator (ledMapping(bMajor[i],i+1), colour);
        }
        feedback(colour);
 
    }
    else if (shape == 2)
    {
        for(int i = 0; i<6; i++)
        {
            illuminator (ledMapping(cMajor[i],i+1), colour);
        }
        feedback(colour);
    }
    else if (shape == 3)
    {
        for(int i = 0; i<6; i++)
        {
            illuminator (ledMapping(dMajor[i],i+1), colour);
        }
        feedback(colour);
    }

    else if (shape == 4)
    {
        for(int i = 0; i<6; i++)
        {
            illuminator (ledMapping(eMajor[i],i+1), colour);
        }
        feedback(colour);
    }
    else if (shape == 5)
    {
        for(int i = 0; i<6; i++)
        {
            illuminator (ledMapping(fMajor[i],i+1), colour);
        }
        feedback(colour);
    }
    else if (shape == 6)
    {
        for(int i = 0; i<6; i++)
        {
            illuminator (ledMapping(gMajor[i],i+1), colour);
        }
        feedback(colour);
    }
    else if (shape == 7)
    {
        for(int i = 0; i<6; i++)
        {
            illuminator (ledMapping(aMinor[i],i+1), colour);
        }
        feedback(colour);
    }
    else if (shape == 8)
    {
        for(int i = 0; i<6; i++)
        {
            illuminator (ledMapping(bMinor[i],i+1), colour);
        }
        feedback(colour);
    }
    else if (shape == 9)
    {
        for(int i = 0; i<6; i++)
        {
            illuminator (ledMapping(cMinor[i],i+1), colour);
        }
        feedback(colour);
    }
    else if (shape == 10)
    {
        for(int i = 0; i<6; i++)
        {
            illuminator (ledMapping(dMinor[i],i+1), colour);
        }
        feedback(colour);
    }
    else if (shape == 11)
    {
        for(int i = 0; i<6; i++)
        {
            illuminator (ledMapping(eMinor[i],i+1), colour);
        }
        feedback(colour);
    }
    else if (shape == 12)
    {
        for(int i = 0; i<6; i++)
        {
            illuminator (ledMapping(fMinor[i],i+1), colour);
        }
        feedback(colour);
    }
    else if (shape == 13)
    {
        for(int i = 0; i<6; i++)
        {
            illuminator (ledMapping(gMinor[i],i+1), colour);
        }
        feedback(colour);
    }
    else if (shape == 14)
    {
        for(int i = 0; i<6; i++)
        {
            illuminator (ledMapping(aSharpMajor[i],i+1), colour);
        }
        feedback(colour);
    }
    else if (shape == 16)
    {
        for(int i = 0; i<6; i++)
        {
            illuminator (ledMapping(cSharpMajor[i],i+1), colour);
        }
        feedback(colour);
    }
    else if (shape == 19)
    {
        for(int i = 0; i<6; i++)
        {
            illuminator(ledMapping(fSharpMajor[i],i+1), colour);
        }
        feedback(colour);
    }
    else if (shape == 20)
    {
        for(int i = 0; i<6; i++)
        {
            illuminator(ledMapping(gSharpMajor[i],i+1), colour);
        }
        feedback(colour);
    }
    else if (shape == 21)
    {
        for(int i = 0; i<6; i++)
        {
            illuminator(ledMapping(aSharpMinor[i],i+1), colour);
        }
        feedback(colour);
    }
    else if (shape == 26)
    {
        for(int i = 0; i<6; i++)
        {
            illuminator(ledMapping(fSharpMinor[i],i+1), colour);
        }
        feedback(colour);
    }
    else
    {
        //this point should never be reached; there are no other chords
        pc.printf ("Error: shaper failed\n");
    }
    // Send the colors to the LED strip.
    ledStrip.write(colors, LED_COUNT);
    if(colour == 1)
    {
       wait(0.5);
       for(int i=0; i < LED_COUNT ; i++)
       {
          colors[i] = (rgb_color){ 0, 0, 0 };
       }
       ledStrip.write(colors, LED_COUNT);
    }

    return (0);
}

int tester (int testChord, int requestChord)
{
 /* if (testChord == 0 || requestChord == 0)
    {
        return (99);
    }
 */
    if (testChord == requestChord)
    {
        return (1);
    }
    else
    {
        return (-1);
    }
}

int interpreter(int requestedCode)
{
/*   int r = 0;
    int chord = 0;
 
    r = rand() % 10;
    chord = rand() % 24;
    if(chord == 0) chord=1;
        
    if(r>1) return(requestedCode);
    else return(chord); */    
}


int main()
{
    pc.baud (921600);
    string chord;
    char typed[20];
    while(1)
    {
        pc.printf("Type in the chord you would like to use \n");
        pc.scanf("%s",typed);
        chordCode = decoder(typed);
        if (chordCode != -99 && chordCode != -1)
        {
            identifier(chordCode);
            shaper(chordCode, 0);
            interpretedChordCode = interpreter(chordCode);
            testResult = tester(interpretedChordCode, chordCode);
        
            while(1)
            {
                if(testResult == -1)
                {
                   wait(2);
                   shaper(chordCode, testResult);
                   wait(0.5);
                   shaper(chordCode, 0);
                   wait(1);
                   interpretedChordCode = interpreter(chordCode);
                   testResult = tester(interpretedChordCode, chordCode);
                }
                else if(testResult == 1)
                {
                   wait(2);
                   shaper(chordCode, testResult);
                   wait(0.5);
                   break;
                }
                else if(testResult == 99)
                {
                    pc.printf("Error");
                    break;
                }
            }
        wait_ms(10);
        }
    }
}