/* Copyright (c) 2010-2016 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include <inttypes.h>
#include "SDRAM_DISCO_F746NG_BlockDevice.h"

// Constructor
//SDRAM_DISCO_F746NG_BlockDevice::SDRAM_DISCO_F746NG_BlockDevice()
//{
//  BSP_SDRAM_Init();
//}

// Destructor
//SDRAM_DISCO_F746NG_BlockDevice::~SDRAM_DISCO_F746NG_BlockDevice()
//{
//  BSP_SDRAM_DeInit();

//}

//=================================================================================================================
// Public methods
//=================================================================================================================

int SDRAM_DISCO_F746NG_BlockDevice::init()
//uint8_t SDRAM_DISCO_F746NG::Init(void)
{
  return BSP_SDRAM_Init();
}

int SDRAM_DISCO_F746NG_BlockDevice::deinit()
{
  return BSP_SDRAM_DeInit();
}

void SDRAM_DISCO_F746NG_BlockDevice::Initialization_sequence(uint32_t RefreshCount)
{
  BSP_SDRAM_Initialization_sequence(RefreshCount);
}

int SDRAM_DISCO_F746NG_BlockDevice::read(void * pData, bd_addr_t uwStartAddress, bd_size_t uwDataSize)
//uint8_t SDRAM_DISCO_F746NG::ReadData(uint32_t uwStartAddress, uint32_t *pData, uint32_t uwDataSize)
{
  return BSP_SDRAM_ReadData(uwStartAddress,(uint32_t *) pData, uwDataSize);
}

uint8_t SDRAM_DISCO_F746NG_BlockDevice::ReadData_DMA(uint32_t uwStartAddress, uint32_t *pData, uint32_t uwDataSize)
{
  return BSP_SDRAM_ReadData_DMA(uwStartAddress, pData, uwDataSize);
}

int SDRAM_DISCO_F746NG_BlockDevice::program(const void *pData, bd_addr_t uwStartAddress, bd_size_t uwDataSize)
//uint8_t SDRAM_DISCO_F746NG::WriteData(uint32_t uwStartAddress, uint32_t *pData, uint32_t uwDataSize) 
{
  return BSP_SDRAM_WriteData(uwStartAddress, (uint32_t *) pData, uwDataSize);
}

uint8_t SDRAM_DISCO_F746NG_BlockDevice::WriteData_DMA(uint32_t uwStartAddress, uint32_t *pData, uint32_t uwDataSize) 
{
  return BSP_SDRAM_WriteData_DMA(uwStartAddress, pData, uwDataSize);
}

uint8_t SDRAM_DISCO_F746NG_BlockDevice::Sendcmd(FMC_SDRAM_CommandTypeDef *SdramCmd)
{
  return BSP_SDRAM_Sendcmd(SdramCmd);
}

int SDRAM_DISCO_F746NG_BlockDevice::erase(bd_addr_t addr, bd_size_t size)
{
  uint32_t tmpIndex;
  uint32_t Value = 0;
  uint64_t PSize = SDRAM_DISCO_F746NG_BlockDevice::get_program_size();
  uint64_t DSize = SDRAM_DISCO_F746NG_BlockDevice::size();
  
  uint32_t UDSize=(uint32_t) DSize;
  uint32_t UPSize=(uint32_t) PSize;  
  uint32_t UAddr=(uint32_t) addr; 
  
  uint32_t *pBuffer = (uint32_t *)malloc(UPSize * sizeof(uint32_t));;

  printf("Erase starting ");
  
  printf("pBuffer mallocated ");

  // Fill buffer with zeroes
  for (tmpIndex = 0; tmpIndex<UPSize; tmpIndex++ ) {
    pBuffer[tmpIndex] = Value;  
  }
  
  printf("pBuffer written\n");

  printf("DSize %lu ", UDSize);
  printf("PSize %lu\n", UPSize); 
  
  // Write the buffer to fill whole device
  for (tmpIndex = 0; tmpIndex<(UDSize/UPSize); tmpIndex++ ) {
    // printf("Index %lu WAddr %#032x% %#032x% %lu EndIndex %lu \n", tmpIndex,(SDRAM_DEVICE_ADDR + UAddr+(tmpIndex*UPSize)),&pBuffer,(UDSize/UPSize));
    // wait(1);
    BSP_SDRAM_WriteData((SDRAM_DEVICE_ADDR + UAddr+(tmpIndex*UPSize)),pBuffer,UPSize);
  }
  
  free(pBuffer);
  pBuffer=NULL;
  return 0;
}
     
bd_size_t SDRAM_DISCO_F746NG_BlockDevice::get_read_size() const
{
  return 1024;
}

bd_size_t SDRAM_DISCO_F746NG_BlockDevice::get_program_size() const
{
  return 1024;
}

bd_size_t SDRAM_DISCO_F746NG_BlockDevice::get_erase_size() const
{
  return 1048576;
}

bd_size_t SDRAM_DISCO_F746NG_BlockDevice::size() const
{
  return 1048576;
}
