// LoadCell_STM32_SDRAM main header
// (C) Tapio Valli 2018-02-20

#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <ctype.h>
#include <errno.h>

#include "LCD_DISCO_F746NG.h"
#include "SDRAM_DISCO_F746NG_BlockDevice.h"
#include "FATFileSystem.h"

extern SDRAM_DISCO_F746NG_BlockDevice bd; 
extern FATFileSystem fs;
extern Serial pc;
extern LCD_DISCO_F746NG lcd;

typedef struct {
  uint16_t *array;
  size_t used;
  size_t size;
} Array;

// Prototypes

extern void initArray(Array *a, size_t initialSize);
extern void insertArray(Array *a, uint32_t newsize);
extern void freeArray(Array *a);

extern size_t string_parser(char *input, char ***word_array);
extern void PlotData(uint32_t XCoordinate,uint32_t YCoordinate);
extern void InitScreen(uint32_t BackGroundColor,uint32_t ForeGroundColor);
extern void LCDWrite(uint32_t Line,char Str[],Text_AlignModeTypdef AlingMode);
extern void CountDown(uint32_t millisecs);
extern void SamplePoints(Array *Data,uint32_t NoOfPoints,uint32_t Period_us);
extern void AvgAndPlotPoints(Array *Data,uint32_t NoOfPoints, uint32_t AvgSize);

extern void BlockDeviceErase();
extern void MountFS();
extern void WriteData2FS(Array *Data,uint32_t NoOfPoints,uint32_t FileNumber);
extern void ReadFile2Data(Array *Data,uint32_t NoOfPoints,uint32_t FileNumber);
extern void DirListing(void);
extern uint32_t GetFileSize(FILE *fp);
