// LoadCell_STM32_RAM v2 main header
// (C) Tapio Valli 2018-02-20

typedef struct {
  uint32_t *array;
  size_t used;
  size_t size;
} Array;

// Prototypes

extern void initArray(Array *a, size_t initialSize);
extern void insertArray(Array *a, uint32_t element);
extern void freeArray(Array *a);

extern size_t string_parser(char *input, char ***word_array);
extern void PlotData(uint32_t XCoordinate,uint32_t YCoordinate);
extern void InitScreen(uint32_t BackGroundColor,uint32_t ForeGroundColor);
extern void LCDWrite(uint32_t Line,char Str[],Text_AlignModeTypdef AlingMode);
extern void CountDown(uint32_t millisecs);
extern void SamplePoints(Array *Data,uint32_t NoOfPoints,uint32_t Period_us);
extern void AvgAndPlotPoints(Array *Data,uint32_t NoOfPoints, uint32_t AvgSize);
