// LoadCell_STM32_RAM v2 functions
// (C) Tapio Valli 2018-02-17

#include "mbed.h"
#include "LCD_DISCO_F746NG.h"

#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <ctype.h>

#include "main.h"

// define the Serial object
Serial pc2(USBTX, USBRX);

LCD_DISCO_F746NG lcd2;

void initArray(Array *a, size_t initialSize) {
  a->array = (uint32_t *)malloc(initialSize * sizeof(uint32_t));
  a->used = 0;
  a->size = initialSize;
}

void insertArray(Array *a, uint32_t element) {
  // a->used is the number of used entries, because a->array[a->used++] 
  // updates a->used only *after* the array has been accessed.
  // Therefore a->used can go up to a->size
   
  if (a->used == a->size) {
    a->size *= 2;
    a->array = (uint32_t *)realloc(a->array, a->size * sizeof(uint32_t));
  }
  a->array[a->used++] = element;
}

void freeArray(Array *a) {
  free(a->array);
  a->array = NULL;
  a->used = a->size = 0;
}

size_t string_parser(char *input, char ***word_array) 
{
    size_t n = 0;
    const char *p = input;

    while ( *p )
    {
        while ( isspace( ( unsigned char )*p ) ) ++p;
        n += *p != '\0';
        while ( *p && !isspace( ( unsigned char )*p ) ) ++p;
    }

    if ( n )
    {
        size_t i = 0;

        *word_array = (char**)malloc( n * sizeof( char * ) ); 

        p = input;

        while ( *p )
        {
            while ( isspace( ( unsigned char )*p ) ) ++p;
            if ( *p )
            {
                const char *q = p;
                while ( *p && !isspace( ( unsigned char )*p ) ) ++p;

                size_t length = p - q;

                ( *word_array )[i] = ( char * )malloc( length + 1 );

                strncpy( ( *word_array )[i], q, length );
                ( *word_array )[i][length] = '\0';

                ++i;
            }
        }           
    }

    return n;
}  

void PlotData(uint32_t XCoordinate,uint32_t YCoordinate)
{
    // Plot at x,y
    lcd2.DrawHLine(XCoordinate,YCoordinate,1);        
}

void InitScreen(uint32_t BackGroundColor,uint32_t ForeGroundColor)
{

// #define LCD_COLOR_BLUE          ((uint32_t)0xFF0000FF)
// #define LCD_COLOR_GREEN         ((uint32_t)0xFF00FF00)
// #define LCD_COLOR_RED           ((uint32_t)0xFFFF0000)
// #define LCD_COLOR_CYAN          ((uint32_t)0xFF00FFFF)
// #define LCD_COLOR_MAGENTA       ((uint32_t)0xFFFF00FF)
// #define LCD_COLOR_YELLOW        ((uint32_t)0xFFFFFF00)
// #define LCD_COLOR_LIGHTBLUE     ((uint32_t)0xFF8080FF)
// #define LCD_COLOR_LIGHTGREEN    ((uint32_t)0xFF80FF80)
// #define LCD_COLOR_LIGHTRED      ((uint32_t)0xFFFF8080)
// #define LCD_COLOR_LIGHTCYAN     ((uint32_t)0xFF80FFFF)
// #define LCD_COLOR_LIGHTMAGENTA  ((uint32_t)0xFFFF80FF)
// #define LCD_COLOR_LIGHTYELLOW   ((uint32_t)0xFFFFFF80)
// #define LCD_COLOR_DARKBLUE      ((uint32_t)0xFF000080)
// #define LCD_COLOR_DARKGREEN     ((uint32_t)0xFF008000)
// #define LCD_COLOR_DARKRED       ((uint32_t)0xFF800000)
// #define LCD_COLOR_DARKCYAN      ((uint32_t)0xFF008080)
// #define LCD_COLOR_DARKMAGENTA   ((uint32_t)0xFF800080)
// #define LCD_COLOR_DARKYELLOW    ((uint32_t)0xFF808000)
// #define LCD_COLOR_WHITE         ((uint32_t)0xFFFFFFFF)
// #define LCD_COLOR_LIGHTGRAY     ((uint32_t)0xFFD3D3D3)
// #define LCD_COLOR_GRAY          ((uint32_t)0xFF808080)
// #define LCD_COLOR_DARKGRAY      ((uint32_t)0xFF404040)
// #define LCD_COLOR_BLACK         ((uint32_t)0xFF000000)
// #define LCD_COLOR_BROWN         ((uint32_t)0xFFA52A2A)
// #define LCD_COLOR_ORANGE        ((uint32_t)0xFFFFA500)
// #define LCD_COLOR_TRANSPARENT   ((uint32_t)0xFF000000)

    lcd2.Clear(BackGroundColor);
    lcd2.SetBackColor(BackGroundColor);
    lcd2.SetTextColor(ForeGroundColor);
    lcd2.SetFont(&Font20);
}

void LCDWrite(uint32_t Line,char Str[],Text_AlignModeTypdef AlignMode)
{
    char IntStr[50];
    
//    InitScreen(LCD_COLOR_BLACK,LCD_COLOR_WHITE,Font20);
    
    lcd2.ClearStringLine(Line);   
    snprintf(IntStr,50,Str);
    lcd2.DisplayStringAt(0, LINE(Line), (uint8_t *)IntStr, AlignMode);
}

void CountDown(uint32_t millisecs)
{
    InitScreen(LCD_COLOR_BLACK,LCD_COLOR_WHITE);

    LCDWrite(5," ",CENTER_MODE);
    wait_ms(1);

    LCDWrite(5,"Starting in 3... ",CENTER_MODE);
    wait_ms(millisecs);
    
    LCDWrite(5,"Starting in 2... ",CENTER_MODE);
    wait_ms(millisecs);

    LCDWrite(5,"Starting in 1... ",CENTER_MODE);
    wait_ms(millisecs);
    
    InitScreen(LCD_COLOR_BLACK,LCD_COLOR_WHITE);
    LCDWrite(5,"GO!",CENTER_MODE);
}

void SamplePoints(Array *Data,uint32_t NoOfPoints,uint32_t Period_us)
{
    AnalogIn    ain(A0);
    uint32_t i;
  
    // Measure NoOfPoints values (f.ex. 19200) 
    for(i=0;i<NoOfPoints;i++) {
        Data->array[i]=(uint32_t)((0x0000 << 16) | ain.read_u16());
        wait_us(Period_us);
    }

    InitScreen(LCD_COLOR_BLACK,LCD_COLOR_WHITE);
    LCDWrite(5,"DONE!",CENTER_MODE);

    pc2.printf("Sampling done.\r\n",i);
}

void AvgAndPlotPoints(Array *Data,uint32_t NoOfPoints, uint32_t AvgSize) {
    
    uint32_t i1,i2;
    
    uint32_t BufferSum,BufferAvg;
    uint32_t XCoord,YCoord;
    char MyStr[50];
    
    pc2.printf("Start reading... \r\n");
    InitScreen(LCD_COLOR_BLACK,LCD_COLOR_RED);  

    for(i1=0;i1<NoOfPoints;i1++) {
        BufferSum=0;
        
        // Read AvgSize samples
        for(i2=i1;i2<i1+AvgSize;i2++) {
            BufferSum=BufferSum+Data->array[i2];
        }
        
        BufferAvg=BufferSum/AvgSize;

        // Calculate two coords and plot
        XCoord=((i1*480.0)/NoOfPoints);
        YCoord=(272.0*(BufferAvg/65536.0));
        
        PlotData(XCoord,YCoord);
    }  
    
    pc2.printf("Done all, Points = %u Avg = %u \r\n", i1,AvgSize);

    LCDWrite(0,"",CENTER_MODE);
    snprintf(MyStr,50,"Pnts = %d Avg = %d",NoOfPoints,AvgSize);
    LCDWrite(0,MyStr,RIGHT_MODE);
}
