// LoadCell_STM32_RAM v2 main
// (C) Tapio Valli 2018-02-17

#include "mbed.h"
#include "mbed_stats.h"

#include "LCD_DISCO_F746NG.h"

#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <ctype.h>

#include "main.h"

// define the Serial object
Serial pc1(USBTX, USBRX);
LCD_DISCO_F746NG lcd1;

int main() {

    char CmdBuffer[30];
    char Arg[30]=" ";
    char Cmd[30]=" ";
    size_t n=0;

    uint32_t    NoOfPoints=19200;  
    uint32_t    AvgSize=10;
    uint32_t    Period_us=100;
    uint32_t    Count_ms=1000;
    
    mbed_stats_heap_t heap_stats;
        
    // Clear screen, set it up 
    InitScreen(LCD_COLOR_BLACK,LCD_COLOR_WHITE);
        
    //Initialize data storage
    Array Data;
    initArray(&Data,NoOfPoints);  // initially 19200 elements
    
    while (!((strcmp(Cmd,"quit")==0)&&(n==1))) {
        
        // Print Ready and current settings 
        pc1.printf("Ready. Settings are Points = %u, Avg = %u, Period_us = %u, Count_ms = %u \r\n",
                   NoOfPoints,AvgSize,Period_us,Count_ms);
                   
        mbed_stats_heap_get(&heap_stats);
        printf("Current heap: %lu\r\n", heap_stats.current_size);
        printf("Max heap size: %lu\r\n", heap_stats.max_size);
                                                                            
        pc1.gets(CmdBuffer,30);
        // pc1.printf("I got %s \r\n", CmdBuffer);
        strcpy(Cmd," ");
        strcpy(Arg," ");
                
        // Parse command and possible numeric arg
        char s[] = "Initial string";
        char ** word_array=NULL;
        
        strcpy(s,CmdBuffer);
        n=string_parser(s,&word_array);

        for ( size_t i=0;i<n;i++) {
            if (i==0) {strcpy(Cmd,word_array[i]);}
            if (i==1) {strcpy(Arg,word_array[i]);}
            if (i>1) {pc1.printf("Wrong number of arguments \r\n");}
        }
        
        // pc1.printf("Cmd = %s Arg = %s \r\n",Cmd,Arg);
        for ( size_t i=0;i<n;i++) free( word_array[i] );
        free(word_array);
    
        // Branch based on command        
        // meas: Sample and plot a data set
        if((strcmp(Cmd,"meas")==0)&&(n==1)) {
            
            // Countdown
            CountDown(Count_ms);
                                 
            // Sample & plot data one time
            SamplePoints(&Data,NoOfPoints,Period_us);
            AvgAndPlotPoints(&Data,NoOfPoints,AvgSize);
        }
        
        // setpoints: Adjust sampled points                          
        else if((strcmp(Cmd,"setpoints")==0)&&(n==2)) {
            // Allocate more or less data space
            NoOfPoints=(uint32_t) strtol(Arg,NULL,10);
            insertArray(&Data,NoOfPoints);
        }
            
        // setavg: Adjust average amount in samples            
        else if((strcmp(Cmd,"setavg")==0)&&(n==2)) {
            AvgSize=(uint32_t) strtol(Arg,NULL,10);
        }
            
        // setperiod: Adjust sample period in us
        else if((strcmp(Cmd,"setperiod")==0)&&(n==2)) {
            Period_us=(uint32_t) strtol(Arg,NULL,10);
        }
        
        // setcount: Adjust countdown period in ms
        else if((strcmp(Cmd,"setcount")==0)&&(n==2)) {
            Count_ms=(uint32_t) strtol(Arg,NULL,10);
        }
        
        // quit: Exit on next while
        else if((strcmp(Cmd,"quit")==0)&&(n==1)) {
            // Do nothing yet
        }
        else {
            pc1.printf("Wrong command or argument \r\n");
        }
    }
    
    // Free memory after quit
    freeArray(&Data);
    pc1.printf("Exit. Data freed. \r\n");
    
    // Infinite loop
    while(1) 
    {
        // Do nothing
    }
}
