#include "mbed.h"
#include "uLCD_4DGL.h"

Serial pc(USBTX, USBRX);
uLCD_4DGL lcd(p13, p14, p15);
AnalogIn ain(p20);


char PC_message[256];
int  PC_message_counter=0;
int  PC_message_length=0;


void setup_lcd(){
    lcd.baudrate(3000000);
    lcd.background_color(0);
    lcd.cls();
    lcd.printf("Initializing...");
}


void update_lcd(){
    lcd.cls();
    lcd.locate(0,0);
    for(int i=0;i<PC_message_length;i++){
        lcd.printf("%c",PC_message[i]);
         wait(0.01);
    }
}


void PC_serial_ISR() {
    char buf;
    
     while (pc.readable()) {
        buf = pc.getc();
        
        PC_message[PC_message_counter]=buf;
        PC_message_counter+=1;
        
        if (buf=='\n'){
            PC_message_length=PC_message_counter-1;
            PC_message_counter=0; 
            
            update_lcd();
        }   
    }
}


int main() {
    pc.baud(9600);
    pc.attach(&PC_serial_ISR);
    setup_lcd();
   
    while (1) {
        pc.printf("%2.2f\n",ain.read()*1.0f);
        wait(1);
    }
}