/*
Magnet encoder reading code for Omnibot Wind Field Mapping

Purpose:    This code reads quadrature pulses from magnet encoder, 
            convert to angular position (degree)
            send out the reading through serial port
            
Note:   LED1: System Status Indicator, Blink = Main Loop is Running
        LED2: Timer Interrupt Service Indicator, Blink = Encoder value is updating
        Quadrature A, B is connected to Pin29,Pin30, and Pin27 for index channel
      
Qiuyang Tao
Georgia Tech System Research
Georgia Institute of Technology
*/
 
#include "mbed.h"
#include "QEI.h"
#define PULSE_PER_REV 1024
#define TIMER_ISR_PERIOD 0.5
  
Ticker ctrl_updt_timer;     //Timer
Serial pc(USBTX, USBRX);    //debug serial
Serial serCOM(p9,p10);
QEI wheel (p29, p30, NC, PULSE_PER_REV);  // <500,000 pulses per second
//QEI wheel (p29, p30, p27, PULSE_PER_REV); // If use encoder's index channel 

//Define LED indicators
DigitalOut led1(LED1); //System Status Indicator,   Blink = Main Loop is Running
DigitalOut led2(LED2); //Timer ISR Indicator,       Blink = Encoder is Updating  
DigitalOut led3(LED3); // 
DigitalOut led4(LED4); //Encoder Overflow Indicator

//use Unsigned long long if overflows frequently
//unsigned long long wheel_revolutions = 0;
int wheel_pulses=0; //number of revolutions recorded by the encoder on the index channel
float wheel_position=0; //position of the shaft in degrees

void controller_update_ISR() {
        wheel_pulses=wheel.getPulses();
        
        if(wheel_pulses>2147483647-100){//reset encoder counter if overflows
                      //18446744073709551615; for Unsigned long long
            wheel.reset();   
            wheel_pulses=0; 
            led4 = !led4;
        }else{                          //calc and send angle if not overflow
            wheel_position=wheel_pulses*1.0/PULSE_PER_REV*360.0; 
        }
    
    
    //Send angle using Serial and USB
    pc.printf("Angle= %f\n deg", wheel_position);
    
    
    //Update LED2 status, tell user PID is updating
    led2 = !led2;   
    
    //Watch dog can be added here in the future
}
 
int main() {
    //All LEDs Blinks at start up
    led1 = 1;led2 = 1;led3 = 1;led1 = 1;
    wait(0.5);
    led1 = 0;led2 = 0;led3 = 0;led1 = 0;
    wait(0.5);
    led1 = 1;led2 = 1;led3 = 1;led1 = 1;
    wait(0.5);
    led1 = 0;led2 = 0;led3 = 0;led1 = 0;
    wait(0.5);
    
    //Start Timer
    ctrl_updt_timer.attach(&controller_update_ISR, TIMER_ISR_PERIOD); //Update Timer at (1/TIMER_ISR_PERIOD) Hz
    
    while(1) {  //blink LED1
        led1 = !led1;
        wait(0.2);
    }
}