#include "mbed.h"
#include "nRF24L01P.h"
#define Address (0x1d<<1)
#include "MMA8451Q.h"

BusOut rgbled(PTA5,PTA12,PTC8);
MMA8451Q acc(PTE25,PTE24,Address);
Serial pc(USBTX, USBRX); // tx, rx

nRF24L01P my_nrf24l01p(PTD2, PTD3, PTD1, PTD0, PTD5, PTD4);    // mosi, miso, sck, csn, ce, irq
DigitalOut RedLED(PTA5);
float xaxis ,yaxis;

int main()
{
    char count[1];
    char TxDataCnt;
    char temp;


    my_nrf24l01p.powerUp();
    my_nrf24l01p.setRfFrequency(2445);

    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Simple Transmitter (0 - 9 Counter) \r\n");

    TxDataCnt = 1;
    my_nrf24l01p.setTransferSize(TxDataCnt);

    my_nrf24l01p.enable();

  
    while (1) {

        // Send the Transmit buffer via the nRF24L01+
        temp = my_nrf24l01p.write( NRF24L01P_PIPE_P0,count, TxDataCnt );
        
        xaxis=acc.getAccX();
        yaxis=acc.getAccY();
        if((xaxis>=-0.2 && xaxis<=0.2) && (yaxis>=-0.2 && yaxis<=0.2))
        {
                
            rgbled=0x06;
            count[0]=0;
            pc.printf("ok\n\r");
            wait(0.5);
        }
        
        else if((xaxis>-0.6 && xaxis<-0.2) || (xaxis>0.2 && xaxis<0.6 ) || (yaxis>-0.6 && yaxis<-0.2) || (yaxis>0.2 && yaxis<0.6 ) )
        {
            rgbled=0x05;
            count[0]=1;
          pc.printf("not ok\n\r");
            wait(0.5);
        }
        
        else 
        {
            rgbled=0x03;
            count[0]=2;
         pc.printf("emergency!!!!\n\r");
            wait(0.5);   
        }
        pc.printf( "orientation data - %d\r\n",count[0]);
        pc.printf( "Sending %d - %d \r\n",temp,count[0]);
         RedLED = !RedLED;
   } 

        // Toggle LED1 (to help debug Host -> nRF24L01+ communication)
       // RedLED = !RedLED;
            

        
      //  wait(0.01);
    }

