#include "mbed.h"
#include "MMA8451Q.h"
#define ON 0
#define OFF 1
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
PinName const SDA = PTE25;
PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
PinName const SDA = PTB4;
PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
PinName const SDA = PTB1;
PinName const SCL = PTB0;
#else
#error TARGET NOT DEFINED
#endif
#define MMA8451_I2C_ADDRESS (0x1d<<1)
#include "tsi_sensor.h"
/* This defines will be replaced by PinNames soon */
//Esto también es prefabricado (COPIAR) **
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif

AnalogIn IN_DIG(PTB1);
AnalogIn IN_ANA(PTB0);
DigitalOut AZUL(LED3);
int tiempo=0,tecla,ESTADO_LED;
float porcentaje=0;
Ticker contador;
TSIAnalogSlider tsi(ELEC0, ELEC1, 40);
//Definimos que el puerto serie se llama pc
Serial pc(USBTX, USBRX);
//Variable donde se guarda lo leido
char   c = '\0';

//bit usado como flag para procesar datos
bool newdata = false;   //Se pone en true cuando hay nuevos datos
enum {INICIO,ORDEN,FIN,CALCULO,TRANSMICION};
int ESTADO_GENERAL,Actuador,i=0,PROTOCOLO, x, y, z,ESTADO_TRANSMICION,digital=0,hab=0, analogico;
int n,Xxor,Yxor,Zxor,Axor,Dxor;
//Callback cuando se detecta una entrada
void onCharReceived()
{
    c = pc.getc();
    newdata = true;
}

void TI()
{
    if(tiempo>0)tiempo--;
}

int tactil()
{
    porcentaje = tsi.readPercentage(); //Comienza apagado y a medida que mueva el dedo cambia la salida PWM
    if(porcentaje<0.9&&porcentaje>=0.1)tecla=1;
    if(porcentaje==0)tecla=0;
    return tecla;
}
void LED_PAUSADO()
{
    if(tiempo==0) {
        tiempo=250;
        AZUL=!AZUL;

    }

}
void LED_HABILITADO()
{
    if(tiempo==0) {
        if(AZUL==OFF) {
            tiempo=200;
            AZUL=ON;
        } else {
            tiempo=1500;
            AZUL=OFF;
        }

    }
}

int antirebote()
{
    if(IN_DIG<0.1f) {
        digital=0;
        hab=0;
    } else {
        hab=1;
    }
    if(IN_DIG>0.8f&&hab==1) {
        digital=1;
    }
    return digital;
}
int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);

    contador.attach(&TI,0.001);

//Ejecutar onCharReceived por cada entrada por puerto
    pc.attach(&onCharReceived);
    while (true) {
        
        n=tactil();
        if(n==1) {
            ESTADO_TRANSMICION=1;
            LED_HABILITADO();
        } else {
            ESTADO_TRANSMICION=0;
            LED_PAUSADO();
        }
        if(newdata) {
            newdata = false;
            
            switch (ESTADO_GENERAL) {
                default:
                    ESTADO_GENERAL=INICIO;
                    break;
                case INICIO:
                    if (c=='@') {
                        ESTADO_GENERAL=ORDEN;
                        break;
                    } else {
                        c='\0';
                        ESTADO_GENERAL = INICIO;
                        break;
                    }
                case ORDEN:
                    if (c=='1') {
                        ESTADO_GENERAL = FIN;
                        PROTOCOLO = 1;
                        break;
                    }
                    if (c=='2') {
                        ESTADO_GENERAL = FIN;
                        PROTOCOLO = 2;
                        break;
                    }
                    if (c=='3') {
                        ESTADO_GENERAL = FIN;
                        PROTOCOLO = 3;
                        break;
                    }
                    if (c=='4') {
                        ESTADO_GENERAL = FIN;
                        PROTOCOLO = 4;
                        break;
                    }
                    if (c=='5') {
                        ESTADO_GENERAL = FIN;
                        PROTOCOLO = 5;
                        break;
                    } else {
                        c='\0';
                        ESTADO_GENERAL = INICIO;
                        break;
                    }
                case FIN:
                    if (c==')') {
                        ESTADO_GENERAL = INICIO;
                        c='\0';
                        
                        break;
                    } else {
                        c='\0';
                        PROTOCOLO = 0;
                        ESTADO_GENERAL = INICIO;
                        break;
                    }
                
                    
            }
        }
        
        if(PROTOCOLO!=0) {
            
                    x = abs(acc.getAccX())*100;
                    y = abs(acc.getAccY())*100;
                    z = abs(acc.getAccZ())*100;
                    analogico=IN_ANA*100;
                    if(PROTOCOLO==1) {
                        Xxor=1^x;
                    }
                    if(PROTOCOLO==2) {
                        Yxor=2^y;
                    }
                    if(PROTOCOLO==3) {
                        Zxor=3^z;
                    }
                    if(PROTOCOLO==4) {
                        Axor=4^analogico;
                    }
                    if(PROTOCOLO==5) {
                        antirebote();
                        Dxor=5^digital;
                    }
               
                    if(ESTADO_TRANSMICION==1) {
                        if(PROTOCOLO==1) {
                            printf("@1%d%x)\n",x,Xxor);
                        }
                        if(PROTOCOLO==2) {
                            printf("@2%d%x)\n",y,Yxor);
                        }
                        if(PROTOCOLO==3) {
                            printf("@3%d%x)\n",z,Zxor);
                        }
                        if(PROTOCOLO==4) {
                            printf("@4%d%x)\n",analogico,Axor);
                        }
                        if(PROTOCOLO==5) {
                            antirebote();
                            printf("@5%d%x)\n",digital,Dxor);
                        }
                    }
                   
           
        }
        PROTOCOLO=0;
        
    }
}
