//#if !FEATURE_LWIP
//    #error [NOT_SUPPORTED] LWIP not supported for this target
//#endif

#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPServer.h"
#include "TCPSocket.h"

#include "stm32746g_discovery_audio.h"
#include "stm32746g_discovery_sdram.h"

typedef enum {
    BUFFER_OFFSET_NONE = 0,
    BUFFER_OFFSET_HALF = 1,
    BUFFER_OFFSET_FULL = 2,
} BUFFER_StateTypeDef;

#define AUDIO_BLOCK_SIZE   ((uint32_t)4096)
#define AUDIO_BUFFER_IN     SDRAM_DEVICE_ADDR
#define AUDIO_BUFFER_OUT   (AUDIO_BUFFER_IN + (AUDIO_BLOCK_SIZE * 2))
//#define NETWORK_BUFFER     (AUDIO_BUFFER_OUT + (AUDIO_BLOCK_SIZE * 2))

char temp[AUDIO_BLOCK_SIZE];

volatile uint32_t  audio_rec_buffer_state = BUFFER_OFFSET_NONE;
Serial pc(USBTX, USBRX);
Mutex mutex;
ConditionVariable cond(mutex);
bool done = false;

void tcp_thread(TCPSocket * send_socket)
{
    while (true) {
        mutex.lock();
        do {
            // Wait for a condition to change (network_buffer full)
//            pc.printf("Waiting for condition on mutex ...\n");
            cond.wait();
        } while (!done);
//        pc.printf("sending data over ethernet ...\n");
        int ret = send_socket->send((void *)(temp), AUDIO_BLOCK_SIZE);
        pc.printf("ret = %d\n", ret);
        done = false;
        mutex.unlock();
    }
    
    pc.printf("Worker: Exiting\r\n");
    mutex.unlock();
}

TCPServer srv;
TCPSocket clt_sock;
SocketAddress clt_addr;
EthernetInterface eth;

int main()
{
    pc.baud(115200);
    Timer t;
    // ======================================= setup network ==============================
    eth.set_network("192.168.10.10", "255.255.255.0", "192.168.10.1");
    eth.connect();
    
    pc.printf("The target IP address is '%s'\n", eth.get_ip_address());
        
    /* Open the server on ethernet stack */
    srv.open(&eth);
    
    /* Bind the HTTP port (TCP 80) to the server */
    srv.bind(eth.get_ip_address(), 8000);
    
    /* Can handle 5 simultaneous connections */
    srv.listen(5);
    
    // ======================== audio part ============================
    pc.printf("\n\nAUDIO LOOPBACK EXAMPLE START:\n");

//    BSP_AUDIO_IN_OUT_Init(INPUT_DEVICE_DIGITAL_MICROPHONE_2, OUTPUT_DEVICE_HEADPHONE, DEFAULT_AUDIO_IN_FREQ, DEFAULT_AUDIO_IN_BIT_RESOLUTION, DEFAULT_AUDIO_IN_CHANNEL_NBR);
    BSP_AUDIO_IN_OUT_Init(INPUT_DEVICE_DIGITAL_MICROPHONE_2, OUTPUT_DEVICE_HEADPHONE, DEFAULT_AUDIO_IN_FREQ, DEFAULT_AUDIO_IN_BIT_RESOLUTION, 1);

    /* Initialize SDRAM buffers */
    BSP_SDRAM_Init();
    memset((void *)AUDIO_BUFFER_IN, 0, AUDIO_BLOCK_SIZE * 2);
    memset((void *)AUDIO_BUFFER_OUT, 0, AUDIO_BLOCK_SIZE * 2);
//    memset((void *)NETWORK_BUFFER, 0, AUDIO_BLOCK_SIZE * 2);
    pc.printf("SDRAM init done\n");

    audio_rec_buffer_state = BUFFER_OFFSET_NONE;

    /* Start Recording */
    if (BSP_AUDIO_IN_Record((uint16_t *)AUDIO_BUFFER_IN, AUDIO_BLOCK_SIZE) != AUDIO_OK) {
        pc.printf("BSP_AUDIO_IN_Record error\n");
    }

    /* Start Playback */
    BSP_AUDIO_OUT_SetAudioFrameSlot(CODEC_AUDIOFRAME_SLOT_02);
    if (BSP_AUDIO_OUT_Play((uint16_t *)AUDIO_BUFFER_OUT, AUDIO_BLOCK_SIZE * 2) != AUDIO_OK) {
        pc.printf("BSP_AUDIO_OUT_Play error\n");
    }
    
    int ret;
    
    while (true) {
        srv.accept(&clt_sock, &clt_addr);
        pc.printf("accept %s:%d\n", clt_addr.get_ip_address(), clt_addr.get_port());

//        Thread thread;
//        thread.start(callback(tcp_thread, &clt_sock));

        int sleep_ms = 20;

        while (1) {
            /* Wait end of half block recording */
            t.start();            
            while (audio_rec_buffer_state != BUFFER_OFFSET_HALF) {
                wait_ms(sleep_ms);
            }
            t.stop();
            printf("t = %f\n", t.read());
            t.reset();

            audio_rec_buffer_state = BUFFER_OFFSET_NONE;

            /* Copy recorded 1st half block */
            memcpy((void *)(AUDIO_BUFFER_OUT), (void *)(AUDIO_BUFFER_IN), AUDIO_BLOCK_SIZE);
            
//            mutex.lock();
//            memcpy((void *)temp, (void *)(AUDIO_BUFFER_IN), AUDIO_BLOCK_SIZE);
//            done = true;
//            cond.notify_all();
//            mutex.unlock();

            memcpy((void *)temp, (void *)(AUDIO_BUFFER_IN), AUDIO_BLOCK_SIZE);
            int ret = clt_sock.send((void *)(temp), AUDIO_BLOCK_SIZE);
            pc.printf("ret = %d\n", ret);
    
            /* Wait end of one block recording */
            while (audio_rec_buffer_state != BUFFER_OFFSET_FULL) {
                wait_ms(sleep_ms);
            }
            audio_rec_buffer_state = BUFFER_OFFSET_NONE;
    
            /* Copy recorded 2nd half block */
            memcpy((void *)(AUDIO_BUFFER_OUT + (AUDIO_BLOCK_SIZE)), (void *)(AUDIO_BUFFER_IN + (AUDIO_BLOCK_SIZE)), AUDIO_BLOCK_SIZE);

            memcpy((void *)temp, (void *)(AUDIO_BUFFER_IN + AUDIO_BLOCK_SIZE), AUDIO_BLOCK_SIZE);
            ret = clt_sock.send((void *)(temp), AUDIO_BLOCK_SIZE);
            pc.printf("ret = %d\n", ret);

//            mutex.lock();
//            memcpy((void *)temp, (void *)(AUDIO_BUFFER_IN + AUDIO_BLOCK_SIZE), AUDIO_BLOCK_SIZE);
//            done = true;
//            cond.notify_all();
//            mutex.unlock();
        }
    }
}

void BSP_AUDIO_IN_TransferComplete_CallBack(void)
{
    audio_rec_buffer_state = BUFFER_OFFSET_FULL;
}

void BSP_AUDIO_IN_HalfTransfer_CallBack(void)
{
    audio_rec_buffer_state = BUFFER_OFFSET_HALF;
}

void BSP_AUDIO_IN_Error_CallBack(void)
{
    printf("BSP_AUDIO_IN_Error_CallBack\n");
}
