#include "mbed.h" 
#include "ble/BLE.h" 
#include "ble/services/HeartRateService.h" 
#include "ble/services/BatteryService.h" 
#include "ble/services/DeviceInformationService.h" 
#include "rtos.h" 
#include <string.h> 
#include "SDFileSystem.h"

Semaphore one_slot(1); 

SDFileSystem sd(p25, p28, p29, p21, "sd");
BLE ble; 
int address[10][12]={}; 
const GapScanningParams scanningParams; 


int counter= 0; 
void onScanCallback(const Gap::AdvertisementCallbackParams_t *params) 
{ 
time_t seconds = time(NULL); // JST 
struct tm *t = localtime(&seconds); 
/*printf("%04d/%02d/%02d %02d:%02d:%02d\r\n", 
t->tm_year + 1900, t->tm_mon, t->tm_mday, t->tm_hour, t->tm_min, t->tm_sec); 
*/ 

int i=0,a=0,b=0,flag=0; 
for(i=0;i<10;i++){ 
if(address[i][0]==params->peerAddr[5]){ 
flag=1; 
break; 
} 
} 
if(flag==0){ 
for(i=0; i<6; i++){ 
address[counter][i]=params->peerAddr[5-i]; 
} 
time_t seconds = time(NULL); 
struct tm *t = localtime(&seconds); 
address[counter][6]=t->tm_year; 
address[counter][7]=t->tm_mon; 
address[counter][8]= t->tm_mday; 
address[counter][9]= t->tm_hour; 
address[counter][10]= t->tm_min; 
address[counter][11]= t->tm_sec; 

counter++; 
for(a=0; a<counter; a++){ 
for(b=0; b<12 ; b++){ 
    FILE *fp = fopen("/sd/mydata/sdtest.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
if(b==0){printf("DEV:"); 
fprintf(fp,"DEV:");} 
if(b<6){printf("%02x ", address[a][b]); 
fprintf(fp,"%02x ", address[a][b]);} 
else if(b>5){printf("%02d:",address[a][b]); 
fprintf(fp,"%02d:",address[a][b]);} 
if(b==11){ 
printf("\r\n"); 
fprintf(fp,"\r\n"); 
 fclose(fp); 

} 
} 

if(a==counter-1)printf("----------\n\r"); 
} 
} 


/* for(int i=0; i<6; i++){ 
address[0][i]=params->peerAddr[5-i]; 
} 
for(int b=0; b<6 ; b++){ 
if(b==0)printf("DEV:"); 
printf("%02x ", address[0][b]); 
if(b==5)printf("\n\r"); 
}*/ 
} 


void test_thread(void const *name) { 


while (true) { 
Timer timer; 
one_slot.wait(); 
printf("%s\n\r", (const char*)name); 
//1 
if(!strcmp((const char*)name, "1")){ 
printf("**this is 1**\n\r"); 
ble.gap().stopAdvertising(); 
ble.startScan(&onScanCallback); 

} 

//2 
if(!strcmp((const char*)name, "2")){ 
printf("**this is 2**\n\r"); 
timer.start(); 
while(1){ 
ble.waitForEvent(); 
if(timer.read() > 9){ 
timer.stop(); 
timer.reset(); 
ble.stopScan(); 
break; 
} 
} 
} 
//3 
if(!strcmp((const char*)name, "3")){ 
printf("**this is 3**\n\r"); 
ble.gap().startAdvertising(); 

} 


Thread::wait(10000); 
one_slot.release(); 
} 
} 

// const static char DEVICE_NAME[] = "BLE1";

void bleInitComplete(BLE::InitializationCompleteCallbackContext *params) 
{ 
BLE &ble = params->ble; 
ble_error_t error = params->error; 

if (error != BLE_ERROR_NONE) { 
return; 
} 
const uint8_t address1[] = {0xAA,0xAA,0xAA,0xAA,0xAA,0xAA}; 
ble.gap().setAddress(BLEProtocol::AddressType::PUBLIC, address1); 
// ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME)); 
// ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED); 
// ble.gap().setAdvertisingInterval(1000); /* 1000ms. */ 
} 

int main (void) { 

mkdir("/sd/mydata", 0777);
    
//ble.init(); 
ble.init(bleInitComplete); 
ble.setScanParams(GapScanningParams::SCAN_INTERVAL_MAX, 
GapScanningParams::SCAN_WINDOW_MAX, 0); 




Thread t2(test_thread, (void *)"2"); 
Thread t3(test_thread, (void *)"3"); 

test_thread((void *)"1"); 

}