#include "mbed.h"
//#include "stm32f4xx.h"
#include "USBHostGamepad.h"

USBHostGamepad *pad;

// init pin
DigitalOut UP(A0);
DigitalOut DOWN(A1);
DigitalOut LEFT(A2);
DigitalOut RIGHT(A3);
DigitalOut FIRE1(A4);
DigitalOut FIRE2(A5);

int main()
{    
    // USB Gmaepad Initialize
    pad = new USBHostGamepad();
    if (!pad->connect()) {
        printf("USB Gamepad not found.\r\n");
        while(1);
    }

    while(1) {
        USBHost::poll();

//      ==debug==
//      printf("%02x %02x %02x %02x %02x %02x %02x %02x\r\n", pad->report[0],pad->report[1],pad->report[2],pad->report[3],pad->report[4],pad->report[5],pad->report[6],pad->report[7]);
      printf("%02x %02x\r\n", pad->report[0],pad->report[1]);
      wait_ms(16);
//      ==debug==

/*
//        TRI = (pad->report[0] & (1))    ? 0 : 1;    // triangle      
        FIRE1 = (pad->report[0] & (1<<1)) ? 0 : 1;    // circle
        FIRE2 = (pad->report[0] & (1<<2)) ? 0 : 1;    // cross
//        SQU = (pad->report[0] & (1<<3)) ? 0 : 1;    // square
//        L2  = (pad->report[0] & (1<<4)) ? 0 : 1;      // L2
//        R2  = (pad->report[0] & (1<<5)) ? 0 : 1;      // R2
//        L1  = (pad->report[0] & (1<<6)) ? 0 : 1;      // L1
//        R1  = (pad->report[0] & (1<<7)) ? 0 : 1;      // R1

        LEFT = RIGHT = (pad->report[1] & (1))                            ? 0 : 1;   // select
        UP   = DOWN  = (pad->report[1] & (1<<1))                         ? 0 : 1;   // start
        LEFT   = !(pad->report[1] & (1<<2)) & !(pad->report[1] & (1<<3)) ? 0 : 1;   // left
        RIGHT  =  (pad->report[1] & (1<<3))                              ? 0 : 1;   // right
        UP     = !(pad->report[1] & (1<<4)) & !(pad->report[1] & (1<<5)) ? 0 : 1;   // up
        DOWN   =  (pad->report[1] & (1<<5))                              ? 0 : 1;   // down
*/
    }
}
