#include "mbed.h"
#include "CtrlBase.hpp"

DigitalOut leds[] = {LED1, LED2, LED3, LED4};
int numLeds = sizeof(leds)/sizeof(DigitalOut);

class CtrlLEDs{
public:
    static void ALLOFF(){
        for(int i = 0 ; i < numLeds ; i++){
            leds[i] = 0;
        }
    };
    static void ON(int idx){ leds[idx] = 1; };
    static void OFF(int idx){ leds[idx] = 0; };

    static void ON_Bit(int flag) {
        if(numLeds < 4) return;
        
        leds[0] = ((flag & 0b1000) > 0) ? 1 : 0;
        leds[1] = ((flag & 0b0100) > 0) ? 1 : 0;
        leds[2] = ((flag & 0b0010) > 0) ? 1 : 0;
        leds[3] = ((flag & 0x0001) > 0) ? 1 : 0;
        
        printf("0x%04x Lighting.\r\n", flag);
    };  
};

class Counter{
    enum {
        DOWN = -1,
        UP = 1
    };
public:
    Counter(int thresh, bool flg = true): _countSide(flg),_countValue(0), _threshValue(thresh) {};
    void SetCountSide(bool flg){
        _countSide = flg;
        printf("Counter: Mode Changed\r\n");
    };
    bool step(){
        _countValue += _countSide ? UP : DOWN;
        if( _countSide ){
            return _countValue < _threshValue;
        }else{
            return _countValue >= 0;
        }
    };
    void resetValue(){ _countValue = _countSide ? 0 : _threshValue; };
    int getValue(){ return _countValue; };

private:
    bool _countSide;
    int _countValue;
    int _threshValue;
};

int main() {
    CtrlPCSerial pc;
    CtrlUART uart;
    
    Counter myCounter(15);
    CtrlLEDs::ALLOFF();
    char c;
    
    printf("Press \"0\" to set countdown. \"1\" to set countup.\r\n");
    
    while(1) {
        if(pc.isReadable()){
            c = pc.getc();
            if(c == '0') myCounter.SetCountSide(false);
            if(c == '1') myCounter.SetCountSide(true);
        };
        
        CtrlLEDs::ON_Bit(myCounter.getValue());
        if(!myCounter.step()){
            myCounter.resetValue();
        }
        wait(0.5);
    }
}
