#include <mbed.h>

Serial pc(USBTX, USBRX);
Serial uart(p28, p27);

class CtrlBase{
public:
    CtrlBase(Serial& tgt) : _refTarget(tgt){};
    bool isReadable(){
        return _refTarget.readable();
    };
    char getc(){ return _refTarget.getc(); };
    void putc(char c){ _refTarget.putc(c); };
private:
    Serial& _refTarget;
};

class CtrlPCSerial : public CtrlBase {
public:
    CtrlPCSerial(): CtrlBase(pc){};
};

class CtrlUART : public CtrlBase{
public:
    CtrlUART(): CtrlBase(uart){};
};
