#include "mbed.h"

DigitalOut leds[] = {LED1, LED2, LED3, LED4};
int numLeds = sizeof(leds)/sizeof(DigitalOut);

class CtrlLEDs{
public:
    static void ALLOFF(){
        for(int i = 0 ; i < numLeds ; i++){
            leds[i] = 0;
        }
    };
    static void ON(int idx){ leds[idx] = 1; };
    static void OFF(int idx){ leds[idx] = 0; };

    static void ON_Bit(int flag) {
        if(numLeds < 4) return;
        
        leds[0] = ((flag & 0b1000) > 0) ? 1 : 0;
        leds[1] = ((flag & 0b0100) > 0) ? 1 : 0;
        leds[2] = ((flag & 0b0010) > 0) ? 1 : 0;
        leds[3] = ((flag & 0x0001) > 0) ? 1 : 0;
    };  
};

int main() {
    int loopCnt = 0;
    CtrlLEDs::ALLOFF();
    while(1) {
        if(loopCnt<=15){
            CtrlLEDs::ON_Bit(loopCnt);
            loopCnt++;
            if(loopCnt > 15){
                loopCnt = 0;
            }
        }
        wait(0.5);
    }
}
