#include "mbed.h"
#include "SDFileSystem.h"
#include "HeptaXbee.h"
#include "HeptaCamera_GPS.h"
#include "Hepta9axis.h"
#include "HeptaTemp.h"
#include "HeptaBattery.h"
#include"Air_Quality.h"

AnalogIn sensorUV(p18);
AirQuality airqualitysensor;
int current_quality = -1;
PinName analogPin = p15;

Serial pc(USBTX,USBRX);
SDFileSystem sd(p5, p6, p7, p8, "sd");
HeptaXbee xbee(p9,p10);
HeptaCamera_GPS cam_gps(p13, p14,p25,p24);
Hepta9axis n_axis(p28,p27,0xD0,0x18);
HeptaTemp temp(p17);
HeptaBattery battery(p16,p26);

int rcmd = 0,cmdflag = 0;

void commandget()
{
    rcmd=pc.getc();
    cmdflag = 1;
}
void initialize()
{
    rcmd = 0;
    cmdflag = 0;
}
void receive(int *xrcmd, int *xcmdflag)
{
    pc.attach(commandget,Serial::RxIrq);
    *xrcmd = rcmd;
    *xcmdflag = cmdflag;
}
// Interrupt Handler
void AirQualityInterrupt()
{
    AnalogIn sensor(analogPin);
    airqualitysensor.last_vol = airqualitysensor.first_vol;
    airqualitysensor.first_vol = sensor.read()*1000;
    airqualitysensor.timer_index = 1;
}

int main()
{
    pc.baud(9600);
    xbee.baud(9600);
    pc.printf("Xbee Uplink Ok Mode\r\n");
    float bt;
    float temper;
    //char str[100];
    float ax,ay,az;
    float gx,gy,gz;
    float mx,my,mz;
    int rcmd=0,cmdflag=0;
    int flag = 0;
    FILE *dummy = fopen("/sd/dummy.txt","w");
    fclose(dummy);
    while(1) {
        battery.power_saving_mode(&flag,&bt);
        temp.temp_sense(&temper);
        
        wait(0.5);
        xbee.xbee_receive(&rcmd,&cmdflag);
        //receive(&rcmd,&cmdflag);
        xbee.printf("Type q to see commands available.\r\n");
        pc.printf("Type q to see commands available.\r\n");
        if(flag == 1) {
            pc.printf("Low Battery\r\n");
            xbee.printf("Low Battery\r\n");
        } else if(temper > 35.0) {
            pc.printf("High Temperature\n\r");
            xbee.printf("High Temperature\n\r");
        } else if((flag == 1) & (temper > 35.0)) {
            pc.printf("Low Battery and High Temperature\n\r");
            xbee.printf("Low Battery and High Temperature\n\r");
        }
        if (cmdflag == 1) {
           
            pc.printf("Command Get = %d\r\n",rcmd);
            xbee.printf("HEPTA is ready to command\r\n",rcmd);
            switch (rcmd) {
                case 'h':
                    for(int i = 0; i < 50; i++){
                        pc.printf("flag = %d, bt = %.2f [V], temp = %.1f [C]\r\n",flag,bt,temper);
                        xbee.printf("flag = %d, bt = %.2f [V], temp = %.1f [C]\r\n",flag,bt,temper);
                    }
                    break;
                case 'q':
                    xbee.printf("HEPTA Uplink OK\r\n");
                    xbee.printf("a for Air Quality. \r\n");
                    xbee.printf("b for UV Reading. \r\n");
                    xbee.printf("c for Take a snaphot. \r\n");
                    xbee.printf("d for Air Temperature.\r\n");
                    xbee.printf("e for Satellite Attitude. \r\n");
                    xbee.printf("f for GPS Data. \r\n");
                    xbee.printf("h for Housekeeping Data. \r\n");
                    wait(3.0);
                    break;
                case 'a':
                    airqualitysensor.init(analogPin, AirQualityInterrupt);
                    for(int i = 0; i < 50; i++){
                       current_quality=airqualitysensor.slope();
                        if (current_quality >= 0) { // if a valid data returned.
                            if (current_quality == 0){
                                printf("High pollution! Force signal active\n\r");
                                xbee.printf("High pollution! Force signal active\n\r");
                                }
                            else if (current_quality == 1){
                                printf("High pollution!\n\r");
                                xbee.printf("High pollution!\n\r");
                                }
                            else if (current_quality == 2){
                                printf("Low pollution!\n\r");
                                xbee.printf("Low pollution!\n\r");
                                }
                            else if (current_quality == 3){
                                printf("Fresh air\n\r");
                                xbee.printf("Fresh air\n\r");
                                }
                        }
                        wait(1.0);
                    } 
                    break;
                case 'b':
                    float value;
                    for(int i = 0; i < 50; i++){
                        value = sensorUV;
                        pc.printf("\rUV Value = %3.2f%%\r\n",value*100);
                        xbee.printf("\rUV Value = %3.2f%%\r\n",value*100);
                        wait(1.0);
                    }
                    break;
                 case 'c':
                    
                    pc.printf("Camera Snapshot Mode\r\n");
                    pc.printf("Hit Any Key To Take Picture\r\n");
                    xbee.printf("Camera Snapshot Mode\r\n");
                    xbee.printf("Hit Any Key To Take Picture\r\n");
                    while(!xbee.readable()) {}
                    cam_gps.Sync();
                    cam_gps.initialize(HeptaCamera_GPS::Baud115200, HeptaCamera_GPS::JpegResolution320x240);
                    cam_gps.test_jpeg_snapshot_picture("/sd/test.jpg");
                    break;
                case 'd':
                    float temper;
                    for (int i=0;i<50;i++) {
                        temp.temp_sense(&temper);
                        pc.printf("Air Temperature: %f\n\r", temper);
                        xbee.printf("Air Temperature: %f\n\r", temper);
                        wait(1.0);
                    }
                    break;
                case 'e':
                    for (int i=0;i<50;i++) {
                        n_axis.sen_acc(&ax,&ay,&az);
                        n_axis.sen_mag(&mx,&my,&mz);
                        n_axis.sen_gyro(&gx,&gy,&gz);
                        pc.printf("Acceleration: %f,%f,%f\t",ax,ay,az);
                        pc.printf("Magnetism: %f,%f,%f\t",mx,my,mz);
                        pc.printf("Velocity: %f,%f,%f\r\n",gx,gy,gz);
                        xbee.printf("Acceleration: %f,%f,%f\t",ax,ay,az);
                        xbee.printf("Magnetism: %f,%f,%f\t",mx,my,mz);
                        xbee.printf("Velocity: %f,%f,%f\r\n",gx,gy,gz);
                        wait(1.0);
                        }
                    
                break;
                case 'f':
                    
                    cam_gps.gps_setting();
                    int quality=0,stnum=0,gps_check=0;
                    char ns='A',ew='B',aunit='m';
                    float time=0.0,latitude=0.0,longitude=0.0,hacu=0.0,altitude=0.0;
                    for(int i=1; i<50; i++) {
                        cam_gps.gga_sensing(&time, &latitude, &ns, &longitude, &ew, &quality, &stnum, &hacu, &altitude, &aunit, &gps_check);
                        if((gps_check==0)|(gps_check==1)) {
                            pc.printf("GPGGA,%f,%f,%c,%f,%c,%d,%d,%f,%f,%c\r\n",time,latitude,ns,longitude,ew,quality,stnum,hacu,altitude,aunit);
                            xbee.printf("GPGGA,%f,%f,%c,%f,%c,%d,%d,%f,%f,%c\r\n",time,latitude,ns,longitude,ew,quality,stnum,hacu,altitude,aunit);
                            }
                    }
                    break;
                default:
                    pc.printf("Unknown command.\r\n");
                    xbee.printf("Unknown command.\r\n");
            }
            
            xbee.initialize();
        }
        wait(1.0);
    }
}