
typedef struct{
    uint8_t hour;
    uint8_t min;
    uint8_t sec;
} mtime_t;

typedef struct{
    mtime_t currentTime;
    mtime_t newTime;
    bool updateTime;  // true if currentTime needs to be updated with newTime;
} mtime_manager_t;


typedef struct {
    uint8_t month; // 1..12
    uint8_t day;  // 1..31
    uint8_t year;  // 20_XX, 2016 => 16;
}date_t;


typedef struct{
    date_t currentDate;
    date_t newDate;
    bool updateDate;  // true if currentDate needs to be updated with newDate;
} mdate_manager_t;


typedef struct {
    float light;
    float gndV;
    float temp;
    bool led_on;
    mtime_t time;
    date_t date;
} myData_t;

#define MAXBUFFER  90
// bool isInputValid(uint8_t * buffer);

uint8_t eNrDaysPerMonth[12]= {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};