# nRF51822_SimpleChat Extended With Data Measurements & Logger
This repo is derived from the initial SimpleChat Application and is build for BLE Nano Device, used in peripheral mode.
This Application scan and measures some inputs and save them in flash with timestamp. A RTC has been implemented.
Using chat application (available for smart phones) some commands can be send to BLE Nano in order to perform some tasks.
Other types of commands can be send via serial interface from a PC, especially data extraction from flash.

#Usage/Description:
After flashing or power on, the ble device will start to advertise and also its local time counter starts. While initializing, application 
will search through all flash pages, last data previosly written. From this pages will retrieve the last data and time available. 
A Timer Tick (period set to 1 second) is used for updating RTC and for data measurements. When the application starts the data will not be saved
in flash until a command is given to start (xf2). When started, it is recommended after connecting to ble device to set the time and date;
After the date and time updated, activate measurement logging (xf2).

Please be aware that for 5-6 seconds, each 100 seconds the connection is stopped by the application. This is due to fact that 
writing to flash is safe when radio connection is off. When g_MyDataIdx is between 95..100, connection should remain closed.

The Application can use somewhere around 100 flash pages (100K). This means, if data is sampled each second, the pages will start
to overwrite after 100*100 seconds = 2.7 hours. Anyway the data is inserted into logger when it is different compared to previous 
measurement. Therefore the time the flash memory can log is bigger than 2.7 hours.

When retrieving the data log via serial, the format is as follows:
-> page starts with: 
2016_ 4_22 H: 7   => year, month, day, and hour
26:51;363;  1; 15 => minutes: seconds; A3,A4,A5  (no info about digital inputs)
-> following rows up to the next page:
0: 5;364;  1; 15  => minutes: seconds - time delta (time elapsed since last measurement); A3, A4, A5;

#Hardware Connections
The BLE Nano Device is connected to some peripheral components as follows:
* Light Sensor ( A3 input)
* Temperature Sensor (A4 input)
* Gnd Voltage (or anything else) (A5 input)
* Buzzer (D6 output)
* Push Button (D5 input)
[*] Optional: MKUSB 20 Board (for Voltage Supply and for Serial Communication with a PC)

# Supported Commands
From RedBear Chat Application following messages are valid:
* Any message that not start with 'x' is echoed with 'R:' as prefix, and also is send via Serial Interface to PC
* Any message that start with 'x' is interpreted as command:
    * xi0 / xi* except {1,2,3,4} => prints the analog inputs and one digital input (the led status) as uint16 values
    * xi1 /xi2 / xi3 / xi4 =>prints the uint16 value for light, temp, gndV, led status
    * xl => toggle led status
    * xs[0-9][0-9] => buzzer; depending on digits, a digital pwm signal is send to buzzer; to deactivate: xs00
    * xtg => returns the current time
    * xti[0-9]{6} => insert time - exp: xti181004 means: 18H10M and 4 seconds
    * xdg => returns the current date
    * xdi[0-9]{6} => insert date - exp: xti160424 means: 2016 Y, 04 Month, 24 Day
    * xf1 => prints the value of g_MyDataIdx (a value now between 0..99) representing the steps until a new page will be written
            in flash with new data; It also print the current flash page that will be written (between 155 and 255)
    * xf2 => activate measurements logging
    * xf3 => deactivate measurements logging        
    * x* => for invalid syntax a sound for 3 seconds is activated, with a message error
From PC serial interface (with MKUSB 20 Board), following commands apply:
    * xf[0-9] => request printing on serial of a specific flash page ( 0 - current page; 1 - previous page, etc)
    * xd => request dump of all recorded logs (starting with current page)
    * xg => prints the value of g_MyDataIdx (a value now between 0..99) representing the steps until a new page will be written
            in flash with new data;       
    * xca => open Radio Advertising  (should be used when the Advertising is Off)
    * xcc => Close Radio connection (should be used when Connection is in Connected state)
    * xcs => Stop Radio Advertising (should be used when Advertising is active)

Other Commands:
    * button push => closes the connection/advertising and turn off the led. If push again reset the previous conditions;

# References
The mbed BLE API is meant to be used in projects on developer.mbed.org. Please see examples and sample project files there. 
A good starting point are these pages:
* [mbed BLE Homepage](http://developer.mbed.org/teams/Bluetooth-Low-Energy/) for all things BLE
* [mbed BLE Getting Started Guide](http://developer.mbed.org/forum/team-63-Bluetooth-Low-Energy-community/topic/5262/) a wonderful primer on using BLE with mbed
* [mbed BLE API page](http://developer.mbed.org/teams/Bluetooth-Low-Energy/code/BLE_API/docs/tip/) for the API in generated by doxygen

For this Application:
* [redBEar Ble Nano] (http://redbearlab.com/blenano/)
* [Project Blog - to be updated](http://tanasaro10.blogspot.ro/)
