#include "myData.h"


uint8_t eNrDaysPerMonth[12]= {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
static uint8_t g_currPage = MAX_PAGE_NUM;  // current page in Flash to be write

uint8_t flash_currPage(){
    return g_currPage;    
}

uint8_t flash_go_nextPage(){
    g_currPage --;
    if (g_currPage < MIN_PAGE_NUM) {
        g_currPage = MAX_PAGE_NUM;
    }
    return g_currPage;    
}


uint8_t flash_prev_N_Page(uint8_t nr_of_pages){
    uint8_t retVal;
    retVal = g_currPage + nr_of_pages;
    
    if (retVal > MAX_PAGE_NUM ) {
        retVal = MIN_PAGE_NUM + (retVal % MAX_PAGE_NUM - 1);
    }
    return retVal;    
}

void search_latest_in_flash(mdate_time_t * outDateTime){
    uint8_t page_nr, sizeB,temp[6];
    uint16_t max_page=(uint16_t)MAX_PAGE_NUM+1u;
    int retVal;
    mdate_time_t max_datetime={16,1,1,0,0,0}, inv_datetime={255,255,255,255,255,255};
    
    sizeB=sizeof(mdate_time_t);
    uint32_t* p_curr_addr;
    
    for (page_nr = MAX_PAGE_NUM; page_nr>= MIN_PAGE_NUM; page_nr --){
        p_curr_addr= (uint32_t *)((uint16_t)BLE_FLASH_PAGE_SIZE * page_nr);
        p_curr_addr += 2; // skip the magic number and the word count                
        
        memcpy(temp, p_curr_addr, sizeB);        
        retVal = memcmp(&temp, &inv_datetime, sizeB);
        if (retVal!=0) {
            retVal  = memcmp(&temp, &max_datetime, sizeB);
                if (retVal >0) {
                        memcpy(&max_datetime, &temp, sizeB);
                        max_page= page_nr;
                }
        }
    }
   
    memcpy(outDateTime, &max_datetime, sizeB);    
    g_currPage= (uint8_t)(max_page-1u);
}

void update_time(mdatetime_manager_t* myDateTimeVar, uint16_t tseconds){
    //memcpy(&myDateTimeVar->newDateTime, &myDateTimeVar->currentDateTime, sizeof(mdate_time_t));    
    if (myDateTimeVar->updateDateTime ==false){
        myDateTimeVar->newDateTime.seconds = (myDateTimeVar->currentDateTime.seconds + tseconds)% 60; 
        myDateTimeVar->newDateTime.minutes = (myDateTimeVar->currentDateTime.minutes + ((tseconds + myDateTimeVar->currentDateTime.seconds) / 60))%60;
        if (myDateTimeVar->newDateTime.minutes< myDateTimeVar->currentDateTime.minutes ) { 
            myDateTimeVar->currentDateTime.hours++;
        }
        myDateTimeVar->newDateTime.hours = (myDateTimeVar->currentDateTime.hours + (tseconds / 3600+myDateTimeVar->newDateTime.minutes/60))%24;
        if (myDateTimeVar->newDateTime.hours < myDateTimeVar->currentDateTime.hours){
            myDateTimeVar->newDateTime.day = (myDateTimeVar->currentDateTime.day + 1)%(eNrDaysPerMonth[myDateTimeVar->currentDateTime.month+1]+1);
            if (myDateTimeVar->newDateTime.day < myDateTimeVar->currentDateTime.day ){
                myDateTimeVar->newDateTime.month = (myDateTimeVar->currentDateTime.month+ 1)%13+1;
                if (myDateTimeVar->newDateTime.month< myDateTimeVar->currentDateTime.month){
                    myDateTimeVar->newDateTime.year = (myDateTimeVar->currentDateTime.year+ 1);
                }
            }         
        }        
    } else {        
        myDateTimeVar->updateDateTime =false;
    }
    
    if (myDateTimeVar->updateDateTime ==true){  // there is a new Date ?        
        myDateTimeVar->updateDateTime =true;
    }
    memcpy(&myDateTimeVar->currentDateTime,&myDateTimeVar->newDateTime, sizeof(mdate_time_t));    
}


int buzz_int(PwmOut* buzzer, uint8_t period, uint8_t duty_cycle){
    int retVal = 0;
    if ((duty_cycle<10)&&(period<10)){
        if (period!=0) {        
            buzzer->period_ms(period);
            *buzzer = (10.0 - (float)duty_cycle)/9.0;        
        } else {
            *buzzer = 0;
        }
    } else {
        retVal=-1;
    }
    return retVal;
}

void assert_error_app(bool condition, Serial *pc, uint16_t error, uint16_t line, const char* file){
    if (condition) {
        pc->printf("App err = %d, line = %d, file = %s\r\n",error, line, file);
    }
}