#include "ble_flash.h"
#include "mbed.h"

#define MAXBUFFER  99u //(((BLE_FLASH_PAGE_SIZE - 4 - sizeof(myData_t))/sizeof(myDataL_t))
#define MAX_WORD_PAGE_DATA 254u // to be computed as round_next_int(MAXBUFFER*sizeof(myDataL_t)+sizeof(myData_t))

#define MAX_PAGE_NUM (NRF_FICR->CODESIZE - 1) // 255
#define MIN_PAGE_NUM 155u


typedef struct{
    uint8_t year;  // 20_XX, 2016 => 16;
    uint8_t month; // 1..12
    uint8_t day;  // 1..31    
    uint8_t hours;
    uint8_t minutes;
    uint8_t seconds;
} mdate_time_t;


typedef struct{
    mdate_time_t currentDateTime;
    mdate_time_t newDateTime;
    bool updateDateTime;  // true if currentTime needs to be updated with newTime;
} mdatetime_manager_t;


typedef enum {
        eStartAdvertising =0,
        eStopAdvertising =1,
        eDisconnect =2
} connection_update_t;

typedef struct {
    uint16_t light;
    uint16_t gndV;
    uint16_t temp;
    bool led_on;
    bool led2_on;    
} myPayload_t;


typedef struct {
    myPayload_t data;
    uint8_t seconds;
    uint8_t minutes;    
} myDataL_t;

typedef struct {
    mdate_time_t datetime; // 6 bytes length
    myPayload_t data; // 8 bytes lenth    
} myData_t;

typedef struct {
    myData_t startData;
    myDataL_t myData[MAXBUFFER];
} myDataLog_t;

typedef struct {
    myData_t startData;
    myDataL_t myData;
} myDataLogShort_t;

/* Return current page to be written in Flash */
uint8_t flash_currPage();

/* Return next page to be written in Flash */
uint8_t flash_go_nextPage();

/* Return  page-N (thas has been written in Flash) */
uint8_t flash_prev_N_Page(uint8_t nr_of_pages);

/*search the latest page written and extract the page_nr, date, and time*/
void search_latest_in_flash(mdate_time_t * outDateTime);

/* Update current date and time with tseconds and also if there is a new date/time given */
void update_time(mdatetime_manager_t* myDateTimeVar, uint16_t tseconds);

/* Update buzzer with period in ms =0..9 and duty cycle = 0..9*/
int buzz_int(PwmOut* buzzer, uint8_t period, uint8_t duty_cycle);

/* Print on serial some error from main app*/
void assert_error_app(bool condition, Serial *pc, uint16_t error, uint16_t line, const char* file);
