/*

Copyright (c) 2012-2014 RedBearLab

Permission is hereby granted, free of charge, to any person obtaining a copy of this software
and associated documentation files (the "Software"), to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:
The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

/*
 *    The application works with the BLEController iOS/Android App.
 *    Type something from the Terminal to send
 *    to the BLEController App or vice verse.
 *    Characteristics received from App will print on Terminal.
 *      Read read_me.md file for more informations about the extended feature
 */


#include "ble/BLE.h"
//#include "LowPowerTicker.h"
#include <myData.h>
#include <Gap.h>
//#include "ble_flash.h"
#include "ble_flash.c"
#include "BatteryService.h"
//#include "DFUService.h"

BLE ble;
//DFUService dfu(ble);

#define BLE_UUID_TXRX_SERVICE            0x0000 /**< The UUID of the Nordic UART Service. */
#define BLE_UUID_TX_CHARACTERISTIC       0x0002 /**< The UUID of the TX Characteristic. */
#define BLE_UUIDS_RX_CHARACTERISTIC      0x0003 /**< The UUID of the RX Characteristic. */

#define TXRX_BUF_LEN                     20  /** For radio message transmission*/

#define MyASSERT(cond , serialpc, errVal) assert_error_app((bool)cond, serialpc, (uint16_t)errVal, __LINE__, __FILE__)


Serial pc(USBTX, USBRX);

//uint8_t batteryLevel=100;
uint16_t nr_of_hits = 0;
uint32_t g_nrOfHits=0;
float gmaxV=0,gminV=3,gmedianV=0.18; // Voltage of the PhotoResistorstatic float measure: max, min, median;

bool bTimeReady = false;
// The Nordic UART Service
static const uint8_t uart_base_uuid[] = {0x71, 0x3D, 0, 0, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_tx_uuid[]   = {0x71, 0x3D, 0, 3, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_rx_uuid[]   = {0x71, 0x3D, 0, 2, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_base_uuid_rev[] = {0x1E, 0x94, 0x8D, 0xF1, 0x48, 0x31, 0x94, 0xBA, 0x75, 0x4C, 0x3E, 0x50, 0, 0, 0x3D, 0x71};

static const int8_t txPower = 0xCD;
//BatteryService *batteryService = NULL;

//uint8_t txPayload[TXRX_BUF_LEN] = {0, p28};
uint8_t txPayload[TXRX_BUF_LEN] = {0,};
uint8_t rxPayload[TXRX_BUF_LEN] = {0,};

static uint8_t rx_buf[TXRX_BUF_LEN];
static uint8_t rx_len=0;

static uint32_t gTimeInstant = 1; // TimerTick Resolution, in seconds


bool g_bIsConnected = false;
bool g_bIsAdvertising = false;
bool g_bConnDisabled = false;
bool g_LogActive = false;// g_bAccEnabled=false, g_bCalib = false;
static myDataLog_t g_MyData;
uint8_t g_MyDataIdx=0;


// pins connected for measuring
DigitalOut led(LED1), //redLed(D4);//, accBuzzAlarm(D3), accLEDAlarm(D5);

//uint8_t tempAlarm, accAlarm;

//PwmOut buzzer(D1); // changed from P15
AnalogIn photoVoltage(A5); // photo voltaga measurement 

myPayload_t g_currMeasures2; // last measurements

//Timeout timeout_err; // timeout for buzz on error
Ticker periodicActions, doMeasures;
mdatetime_manager_t g_myDateTimeVar;
//uint8_t gBatteryValue=0;
GattCharacteristic  txCharacteristic (uart_tx_uuid, txPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);

GattCharacteristic  rxCharacteristic (uart_rx_uuid, rxPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);

GattCharacteristic *uartChars[] = {&txCharacteristic, &rxCharacteristic};

GattService         uartService(uart_base_uuid, uartChars, sizeof(uartChars) / sizeof(GattCharacteristic *));

void decode(uint8_t * buffer, uint16_t length);

void alarm(){
    
    //accBuzzAlarm = 1;
    //accLEDAlarm = 0;
    //timeout_err.attach(&at_timeout_err, 2);
}

void sendRadioMsg(const uint8_t* buf, uint16_t length)
{
    uint8_t retVal;
    retVal = ble.updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), buf, length);
    //pc.printf("Err=%d\r\n",retVal);
    MyASSERT((retVal!=0),&pc, retVal);
}

void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    pc.printf("Disconnected \r\n");
    g_bIsConnected = false;
    g_bIsAdvertising = false;
    pc.printf("R: %d\r",reason);
    if (reason != 0x16) {
        ble.startAdvertising();
        g_bIsAdvertising = true;
    }    
}

void connectionCallback(const Gap::ConnectionCallbackParams_t *params)
{
    pc.printf("Connected \r\n");
    g_bIsConnected = true;
    g_bIsAdvertising = false;
}

void connectionUpdate(connection_update_t option)
{
    if (g_bConnDisabled == false) {
        switch (option) {
            case eStartAdvertising: {
                if ((g_bIsConnected == false)&&(g_bIsAdvertising == false)) {
                    pc.printf("Start Advertising\r");
                    ble.startAdvertising();
                    g_bIsAdvertising = true;
                }
                break;
            }
            case eStopAdvertising: {
                if (g_bIsAdvertising == true) {
                    pc.printf("Stop Advertising\r");
                    ble.stopAdvertising();
                    g_bIsAdvertising = false;
                }
                break;
            }
            case eDisconnect: {
                if (g_bIsConnected == true) {
                    pc.printf("Close connection\r");
                    ble.disconnect((Gap::DisconnectionReason_t)0x12);                    
                } else if (g_bIsAdvertising == true) {
                    pc.printf("Stop Advertising\r");
                    ble.stopAdvertising();
                    g_bIsAdvertising = false;
                }
                break;
            }
        }
    }
}
void write_data_to_flash(uint32_t *tick, myPayload_t * currMeasures)
{
    uint8_t page_num=0;

    if (g_MyDataIdx==0) {
        //initiate connection
        connectionUpdate(eStartAdvertising);
        // time and date used to initialize the g_MyData variable
        memcpy(&g_MyData.startData.datetime,&g_myDateTimeVar.currentDateTime, sizeof(mdate_time_t));        
        memcpy(&g_MyData.startData.data,currMeasures, sizeof(myPayload_t));
    } else {
        // it should be logged here the time difference from last record...
        g_MyData.myData[g_MyDataIdx-1].minutes = (uint16_t)(*tick*gTimeInstant / 60);
        g_MyData.myData[g_MyDataIdx-1].seconds = (*tick*gTimeInstant% 60);
        memcpy(&g_MyData.myData[g_MyDataIdx-1].data,currMeasures, sizeof(myPayload_t));
    }
    *tick = 0;

    if (g_MyDataIdx==(MAXBUFFER-3)) {
        //initiate disconnection
        connectionUpdate(eDisconnect);
    }

    if (g_MyDataIdx == MAXBUFFER) {
        // write2Flash the current page num
        //connectionUpdate(eDisconnect);
        
        page_num=flash_currPage();
        // write2Flash the current page data
        ble_flash_page_write(page_num, (uint32_t*)&(g_MyData), 253);
        memset(&g_MyData,0,sizeof(myDataLog_t));
        //pc.printf("retValWr: %d, Pg:%d, Min: %d \r\n",retVal, page_num,g_myDateTimeVar.currentDateTime.minutes);
        flash_go_nextPage();
    }
    g_MyDataIdx = (g_MyDataIdx+1)%(MAXBUFFER+1);
}


void on_error_radioMsg()
{
    char myBuf[TXRX_BUF_LEN];
    sprintf(myBuf,"%s","WrongSyntax");
    //buzz_int(&buzzer,5,3);
    //timeout_err.attach(&at_timeout_err, 2);
    sendRadioMsg((uint8_t*)&myBuf[0], 12);
}

void flash_page_serial_dump(uint32_t* p_curr_addr)
{
    myDataLogShort_t initialData;
    mdate_time_t * pdate;
    myDataL_t dataOut[2];
    uint8_t i;

    p_curr_addr += 2; // skip the magic number and the word count
    memcpy((uint32_t*)&initialData, p_curr_addr, 3*sizeof(uint32_t));
    pdate = &initialData.startData.datetime;
    pc.printf("20%2d_%2d_%2d H:%2d P:%4x\r",pdate->year, pdate->month, pdate->day, pdate->hours, p_curr_addr);
    pc.printf("%2d:%2d;%3d;%2d:%2d;%3d;\r",pdate->minutes, pdate->seconds, initialData.startData.data.hits,initialData.myData.minutes, initialData.myData.seconds, initialData.myData.data.hits);    
    p_curr_addr += 3;

    for (i=0; i<125; i++) {
        memcpy((uint32_t*)&dataOut, p_curr_addr, 2*sizeof(uint32_t));
        pc.printf("%2d:%2d;%3d;%2d:%2d;%3d;\r",dataOut[0].minutes, dataOut[0].seconds, dataOut[0].data.hits,dataOut[1].minutes, dataOut[1].seconds, dataOut[1].data.hits);        
        p_curr_addr += 2;
    }
}

int sign(int nr){
    int retVal=0;
    if (nr>0) retVal=1;
    else if (nr<0) retVal=-1;
    
    return retVal;    
}

float read_real_value(void){
    uint32_t wrk,reg0,reg1,reg2;
    reg0 = NRF_ADC->ENABLE;     // save register value
    reg1 = NRF_ADC->CONFIG;     // save register value
    reg2 = NRF_ADC->RESULT;     // save register value
    NRF_ADC->ENABLE = ADC_ENABLE_ENABLE_Enabled;
    NRF_ADC->CONFIG = (ADC_CONFIG_RES_10bit << ADC_CONFIG_RES_Pos) |
                      (ADC_CONFIG_INPSEL_SupplyOneThirdPrescaling << ADC_CONFIG_INPSEL_Pos) |
                      (ADC_CONFIG_REFSEL_VBG << ADC_CONFIG_REFSEL_Pos) |
                      (ADC_CONFIG_PSEL_Disabled << ADC_CONFIG_PSEL_Pos) |
                      (ADC_CONFIG_EXTREFSEL_None << ADC_CONFIG_EXTREFSEL_Pos);
    NRF_ADC->EVENTS_END  = 0;
    NRF_ADC->TASKS_START = 1;
    while (!NRF_ADC->EVENTS_END) {;}
    wrk = NRF_ADC->RESULT;      // 10 bit result
    NRF_ADC->ENABLE = reg0;     // recover register value
    NRF_ADC->CONFIG = reg1;     // recover register value
    NRF_ADC->RESULT = reg2;     // recover register value
    NRF_ADC->EVENTS_END  = 0;
    return ((float)wrk / 1024 * 1.2 * 3.0);            
}

uint8_t read100(void)
{ 
    float wrk_vdd, v0p= 2.7 ,v100p= 3.3;
    wrk_vdd = read_real_value();
    if (wrk_vdd <= v0p){
        return 0;
    } else if (wrk_vdd >= v100p){
        led = 0;
        return 100;
        
    }
    led = 1;
    wrk_vdd = (wrk_vdd - v0p) / (v100p - v0p);
    return (uint8_t)(wrk_vdd * 100); 
}


void at_eachInstant()
{
    static uint32_t tick=0;
    static uint8_t ltick=0;
    uint8_t rcBuff[2]={'r','0'};
    //static myPayload_t prevMeasures2=(myPayload_t) { 0, 0, 0, 0};

    // update time
    update_time(&g_myDateTimeVar, gTimeInstant);
   
    //batteryService->updateBatteryLevel(gBatteryValue );
    //update measurements
    if (g_LogActive==true){       
    // if there are changes in data save
        if (0!=g_currMeasures2.hits){            
            write_data_to_flash(&tick, &g_currMeasures2);                                   
    }
    if (g_bIsConnected == true){
    // print info           
        rcBuff[1]='0'+ltick;
        decode(rcBuff,2);
        ltick =(ltick+1)%4;
    }
    tick++;
    
    }
}

void update_measurements()
{
    nr_of_hits ++; 
    g_nrOfHits ++;
    /*if (bNewSample==false){ 
        //g_currMeasures2.hits =nr_of_hits; 
        nr_of_hits = 1;
        bNewSample = true; 
    } */   
    
    //gBatteryValue = read100();              
    
}

void at_eachADC(){
   static bool isLow = false;
   static bool bPrevState=isLow;
   static uint8_t counter = 0;
   static float measure;
   
          
   measure = photoVoltage.read();
   if (g_LogActive==false){
    if (measure > gmaxV) {
       maxV=measure;
    }
    if (measure < minV) {
        gminV=measure;
    }    
    //gmedian = gminV + (gminV + gmaxV)*10/4; % 25%
   }
   
   isLow =  (measure < gmedianV);
   if ((bPrevState != isLow)&&(isLow == true)){
        nr_of_hits ++; 
        g_nrOfHits ++;
       }
    bPrevState = isLow;
   
    counter = (counter + 1)%100;
    if (counter==0){
            // 1 second is passed
            bTimeReady=true;
            g_currMeasures2.hits =nr_of_hits; 
            nr_of_hits = 0;
        }
}

// Radio commands decode
void decode(uint8_t * buffer, uint16_t length)
{
    char myBuf[TXRX_BUF_LEN];
    uint16_t len;
    switch (buffer[0]) {
        case 'r': {// Read Operations
            switch (buffer[1]) {
                case '0':{
                    sprintf(myBuf,"NH:%2d,TNH:%8d\r\n", g_currMeasures2.hits,g_nrOfHits);
                    len = 19;
                    break;
                }
                case '1':{
                    sprintf(myBuf,"P:%1.2f_%1.2f_%1.2f\r\n", gmaxV,photoVoltage.read(),gminV);
                    len = 18;
                    break;
                }
                case '2':{
                sprintf(myBuf,"g_idx=%2d Page=%3d",g_MyDataIdx, flash_currPage());
                    len = 18;
                    break;                    
                }
                case '3': {
                    sprintf(myBuf,"V:%2.3f\r\n", read_real_value());
                    len = 11;
                    break;
                }
                case '4': {
                    sprintf(myBuf,"PhVol:%2.2f,Av:%2.2f\r\n",photoVoltage.read(),gmedian);
                    len = 20;
                    break;
                }
                case '5': {
                    //sprintf(myBuf,"Vmx_mn:%1.2f_%1.2f\r\n",maxV,minV);
                    //len = 18;
                    break;
                }          
                
                default:{
                    sprintf(myBuf,"Nothing \r\n");
                    len = 10;
                    break;
                }
            }
            sendRadioMsg((uint8_t *)myBuf, len);
            break;
        }
        case 'l': {// toogle led
            led = ! led;
            if (led==0) {
                sprintf(myBuf,"%s","OFF");
                len = 2;
            } else {
                sprintf(myBuf,"%s","ON");
                len = 3;
            }
            sendRadioMsg((uint8_t *)myBuf, len);
            break;
        }        
        case 'i':{ // Insert data values
            switch (buffer[1]){
                case 'm':{      // median change              
                        memcpy(myBuf,&buffer[2],2);
                        gmedian=(float)atoi(myBuf)/10; // TODO check if it is a number                                          
                    break;
                }
                
                default: {
                   // on_error_radioMsg();  // notify on radio
                }
            }
            break;
        }
        case 'd':
        case 't': {// date /time operations            
            switch (buffer[1]) {
                case 'i': { // date insert                   
                    uint8_t i; 
                    uint8_t * pdata = &g_myDateTimeVar.newDateTime.year; // to insert data
                    
                    if (buffer[0]=='t') {
                        sprintf(myBuf,"  TimeInserted");
                        pdata +=3;
                    } else {sprintf(myBuf,"  DateInserted");}
                    len= 14;
                    
                    for (i=0;i<3;i++){
                        memcpy(myBuf,&buffer[2+2*i],2);
                        *pdata=atoi(myBuf); // TODO check if it is a number
                        pdata= pdata+1;
                    }
                    g_myDateTimeVar.updateDateTime = true;
                    
                    sendRadioMsg((uint8_t *)myBuf, len);
                    break;
                }
                case 'g': { // time/date get
                uint8_t * pdata1 = &g_myDateTimeVar.currentDateTime.year; // to get data
                   if (buffer[0]=='t') {
                        pdata1 +=3;
                        sprintf(myBuf,"H:%2d:%2d:%2d",*pdata1,*(pdata1+1),*(pdata1+2));
                        len = 11;
                    }else {
                        sprintf(myBuf,"D:20%2d:%2d:%2d",*pdata1,*(pdata1+1),*(pdata1+2));
                        len = 13;
                    }
                    sendRadioMsg((uint8_t *)myBuf, len);
                    break;
                }
                default:
                    MyASSERT(true,&pc, buffer[1]); // notify on serial interface
                    on_error_radioMsg();  // notify on radio
            }
            break;
        }

        case 'f': {// file operations
            switch (buffer[1]) {
                case '1': {                    
                    sprintf(myBuf,"g_idx=%2d Page=%3d",g_MyDataIdx, flash_currPage());
                    len = 18;
                    sendRadioMsg((uint8_t *)myBuf, len);
                    break;
                }
                case '2': { // start measuring
                    sprintf(myBuf,"Start Meas");
                    len = 12;
                    sendRadioMsg((uint8_t *)myBuf, len);
                    g_LogActive = true;
                                      
                    break;
                }
                case '3': { // stop measuring
                    doMeasures.detach();
                    sprintf(myBuf,"Stop Meas");
                    len = 11;
                    sendRadioMsg((uint8_t *)myBuf, len);
                    g_LogActive = false;
                    ble_flash_page_write(flash_currPage(), (uint32_t*)&(g_MyData), 253);
                    memset(&g_MyData,0,sizeof(myDataLog_t));
                    flash_go_nextPage();
                    break;
                }
                case '4':{ 
                    break;
                }
                case '5':{ // read one measure
                                    
                    break;
                }
                default: {
                    // error
                }
            }
            break;
        }
        default: {
            MyASSERT(true,&pc, buffer[1]); // notify on serial interface
            on_error_radioMsg();  // notify on radio;
        }
    }
}

// decode serial command that starts with x
static void decode_s(uint8_t * buffer, uint16_t length)
{
    uint8_t page_nr;
    char myBuf[5];
    uint32_t * p_curr_addr;

    switch (buffer[0]) {
        case 'f': { // info about selected flash page
            if ((buffer[1]<='9')&&(buffer[1]>='0')) {
                memcpy(myBuf,&buffer[1],3);
                page_nr= atoi(myBuf);
                uint8_t p_word_count;

                pc.printf("buffer[1]: %c \r\n",buffer[1]);

                p_curr_addr= (uint32_t *)((uint16_t)BLE_FLASH_PAGE_SIZE * (flash_currPage() - page_nr));
                pc.printf("page_addr: %x, pgNr = %d \r\n",p_curr_addr,(flash_currPage() - page_nr));
                p_curr_addr += 1;
                pc.printf("page_addr: %x \r\n",p_curr_addr);
                p_word_count = (uint8_t)(*(p_curr_addr));
                pc.printf("nr_of_words: %d \r\n",p_word_count);
                flash_page_serial_dump((p_curr_addr-1));
            }
            break;
        }
        case 'd': { // full dump
            uint16_t page0;
            pc.printf("Full dump \r\n");

            page0 = flash_currPage();
            for (page_nr=0; page_nr<=(MAX_PAGE_NUM-MIN_PAGE_NUM); page_nr++) {
                if ((page0-page_nr)< MIN_PAGE_NUM) {
                    page0 = MAX_PAGE_NUM + page_nr;
                }
                p_curr_addr= (uint32_t *)((uint16_t)BLE_FLASH_PAGE_SIZE * (page0-page_nr));
                flash_page_serial_dump(p_curr_addr);
            }
            break;
        }
        case 'g': {
            pc.printf("g_MyDataIdx= %d\r", g_MyDataIdx);
            break;
        }
        case 'c': {
            switch (buffer[1]) {
                case 'a': {
                    connectionUpdate(eStartAdvertising);
                    break;
                }
                case 'c' : {
                    connectionUpdate(eDisconnect);
                    break;
                }
                case 's' : {
                    connectionUpdate(eStopAdvertising);
                    break;
                }
                default:
                    pc.printf("Not recognized cmd !\r");
            }
            break;
        }
        default: {
            // nothing
        }
    }
}

void WrittenHandler(const GattWriteCallbackParams *Handler)
{
    uint8_t buf[TXRX_BUF_LEN+1]= {'R',':',0};
    uint16_t bytesRead;

    if (Handler->handle == txCharacteristic.getValueAttribute().getHandle()) {
        ble.readCharacteristicValue(txCharacteristic.getValueAttribute().getHandle(), &buf[2], &bytesRead);
        memset(txPayload, 0, TXRX_BUF_LEN);
        memcpy(txPayload, &buf[2], bytesRead);
        if (txPayload[0] == 'x') {
            decode(&txPayload[1],bytesRead);
        }
        //echo back
        bytesRead+=2;
        sendRadioMsg(buf, bytesRead);

        // print on PC monitor
        buf[bytesRead]='\r';        
        pc.printf("%s",buf);
    }
}

void uartCB(void)
{
    while(pc.readable()) {
        rx_buf[rx_len++] = pc.getc();
        if(rx_len>=20 || rx_buf[rx_len-1]=='\0' || rx_buf[rx_len-1]=='\n') {
            ble.updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), rx_buf, rx_len);
            if ((rx_buf[0]=='x')) {
                decode_s(&rx_buf[1],(rx_len-1)); // serial decode
            }
            rx_len= 0;
            break;
        }
    }
}


void g_varInit()
{
    g_myDateTimeVar.updateDateTime = true;    
    /* retreive latest date, time and page flash available */
    search_latest_in_flash(&g_myDateTimeVar.newDateTime);    
}

int main(void)
{
    ble.init();
    g_varInit();
    led= 1;
    
    ble.onDisconnection(disconnectionCallback);
    ble.onConnection(connectionCallback);
    ble.onDataWritten(WrittenHandler);
    //event.rise(&button);
    
    
    //event.rise(&accInt1);
    pc.baud(19200);
    pc.printf("SimpleChat Init \r\n");
    
    pc.attach( uartCB , pc.RxIrq);
    // setup advertising
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                     (const uint8_t *)"CntBle3", sizeof("CntBle3") - 1);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                     (const uint8_t *)uart_base_uuid_rev, sizeof(uart_base_uuid));
    //ble.accumulateAdvertisingPayload(GapAdvertisingData::TX_POWER_LEVEL,(const uint8_t *)txPower, sizeof(txPower));
    ble.setTxPower(txPower);
    // 100ms; in multiples of 0.625ms.
    ble.setAdvertisingInterval(160);
    /*
    // activate radio notifications - usefull for flashwrite
    void (*ptrFunc)(bool);
    ptrFunc  = ble_flash_on_radio_active_evt;
    //needed for flash write
    //ble.onRadioNotification(ptrFunc);
    */
    ble.addService(uartService);
    //batteryService = new BatteryService(ble, batteryLevel);
    ble.startAdvertising();
    pc.printf("Advertising Start \r\n");   
    //periodicActions.attach(&at_eachInstant,gTimeInstant);    
    doMeasures.attach_us(&at_eachADC,10000);
    //gBatteryValue = read100();
    while(1) {
        ble.waitForEvent();
        if (bTimeReady==true){
            bTimeReady=false;
            at_eachInstant();
        }
    }
}
