#include "solenoid_valve.h"

PortValve::PortValve(PinName digitalPin1, PinName digitalPin2):
    angle1(digitalPin1),
    angle2(digitalPin2)
{
    valvetTime.start();
    valveDt = 0.0;
}

void PortValve::inputState(int state)
{
    valveDt = valvetTime.read();
    if(((int)state==0)&&(airStatus == 1)) airStatus=1;
    if(((int)state==1)&&(airStatus == 0)) airStatus=0;
    if(((int)state==1) && (airStatus==0)) {
        angle1=0;
        angle2=1;
        airFlag=1;
        airStatus=1;
    } else if(((int)state==0) && (airStatus==1)) {
        angle1=1;
        angle2=0;
        airFlag=1;
        airStatus=0;
    }
    if(airFlag == 1) {
        valvetTime.reset();
        airFlag = 0;
        valveDt = valvetTime.read();
    }

    if((airFlag == 0) && (valveDt > 0.30)) {
        angle1=0;
        angle2=0;
    }

}