#ifndef PETBOTTLE_LOADING_H
#define PETBOTTLE_LOADING_H
#include "ikarashiMDC.h"
#include "PID.h"
#include "QEI.h"
#include "pin_config.h"
//#include "controller.h"

#define loadingKP 29.0
#define loadingKI 0
#define loadingKD 0.0
#define RATE 0.01
/**
 * 装填・発射機構用クラス
 */
class petbottleLoading
{
public:
    /**
    * デフォルトコンストラクタ
    */
    petbottleLoading();

    /**
     *
     * @0:最初の位置
     * @1:発射機構１まで移動モード
     * @2:発射機構２まで移動モード
     * @3:装填して原点に戻りボトルを落とすモード
     */
    void petbottlemode(int loadingmode);

    /**
     *装填機構状態表示
     * @0 : 装填中～～
     * @1 : 装填完了！
     */
    int state();
    int LoadingEncoder();

private:
    /*装填機構*/
    void loadingasenble();
    ikarashiMDC* petbottledrop;
    ikarashiMDC* petbotleslider;
    ikarashiMDC* petbottleIn;
    Serial RS485;
    DigitalOut RS485control;

    double petbottledropPwm, petbotlesliderPwm, petbottleInPwm;
    PID loadingPid;
    QEI loadingencoder;
    InterruptIn limitSW1_,limitSW2_,limitSW3_;
    int limitSW1,limitSW2,limitSW3;
    bool limitSwFlag[3],limitSwFlag2[3], limitStatus[3];
    int nowPals, loadingDistance, pullDistanceOfset;
    double Output_PID;
    int loadingmode;
    bool sw5flag;
    
    /*受信系*/
//    Controller con;
    bool receiveSuccessed;
    Serial debug;
    Timer pt;
    float pdt;


};



#endif
